% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-stepwise-backward-regression.R
\name{ols_step_backward_p}
\alias{ols_step_backward_p}
\alias{ols_step_backward_p.default}
\alias{plot.ols_step_backward_p}
\title{Stepwise backward regression}
\usage{
ols_step_backward_p(model, ...)

\method{ols_step_backward_p}{default}(
  model,
  p_val = 0.3,
  include = NULL,
  exclude = NULL,
  hierarchical = FALSE,
  progress = FALSE,
  details = FALSE,
  ...
)

\method{plot}{ols_step_backward_p}(x, model = NA, print_plot = TRUE, details = TRUE, ...)
}
\arguments{
\item{model}{An object of class \code{lm}; the model should include all
candidate predictor variables.}

\item{...}{Other inputs.}

\item{p_val}{p value; variables with p more than \code{p_val} will be removed
from the model.}

\item{include}{Character or numeric vector; variables to be included in selection process.}

\item{exclude}{Character or numeric vector; variables to be excluded from selection process.}

\item{hierarchical}{Logical; if \code{TRUE}, performs hierarchical selection.}

\item{progress}{Logical; if \code{TRUE}, will display variable selection progress.}

\item{details}{Logical; if \code{TRUE}, will print the regression result at
each step.}

\item{x}{An object of class \code{ols_step_backward_p}.}

\item{print_plot}{logical; if \code{TRUE}, prints the plot else returns a plot object.}
}
\value{
\code{ols_step_backward_p} returns an object of class \code{"ols_step_backward_p"}.
An object of class \code{"ols_step_backward_p"} is a list containing the
following components:

\item{model}{final model; an object of class \code{lm}}
\item{metrics}{selection metrics}
}
\description{
Build regression model from a set of candidate predictor variables by
removing predictors based on p values, in a stepwise manner until there is
no variable left to remove any more.
}
\examples{
# stepwise backward regression
model <- lm(y ~ ., data = surgical)
ols_step_backward_p(model)

# stepwise backward regression plot
model <- lm(y ~ ., data = surgical)
k <- ols_step_backward_p(model)
plot(k)

# selection metrics
k$metrics

# final model
k$model

# include or exclude variables
# force variable to be included in selection process
ols_step_backward_p(model, include = c("age", "alc_mod"))

# use index of variable instead of name
ols_step_backward_p(model, include = c(5, 7))

# force variable to be excluded from selection process
ols_step_backward_p(model, exclude = c("pindex"))

# use index of variable instead of name
ols_step_backward_p(model, exclude = c(2))

# hierarchical selection
model <- lm(y ~ bcs + alc_heavy + pindex + age + alc_mod, data = surgical)
ols_step_backward_p(model, 0.1, hierarchical = TRUE)

# plot
k <- ols_step_backward_p(model, 0.1, hierarchical = TRUE)
plot(k)

}
\references{
Chatterjee, Samprit and Hadi, Ali. Regression Analysis by Example. 5th ed. N.p.: John Wiley & Sons, 2012. Print.
}
\seealso{
Other backward selection procedures: 
\code{\link{ols_step_backward_adj_r2}()},
\code{\link{ols_step_backward_aic}()},
\code{\link{ols_step_backward_r2}()},
\code{\link{ols_step_backward_sbc}()},
\code{\link{ols_step_backward_sbic}()}
}
\concept{backward selection procedures}
