% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ols-studentized-residual-plot.R
\name{ols_plot_resid_stud}
\alias{ols_plot_resid_stud}
\alias{ols_srsd_plot}
\title{Studentized residual plot}
\usage{
ols_plot_resid_stud(model, print_plot = TRUE)
}
\arguments{
\item{model}{An object of class \code{lm}.}

\item{print_plot}{logical; if \code{TRUE}, prints the plot else returns a plot object.}
}
\value{
\code{ols_plot_resid_stud} returns  a list containing the
following components:

\item{outliers}{a \code{data.frame} with observation number and \code{studentized residuals} that
exceed \code{threshold}} for classifying an observation as an outlier
\item{threshold}{\code{threshold} for classifying an observation as an outlier}
}
\description{
Graph for identifying outliers.
}
\details{
Studentized deleted residuals (or externally studentized residuals) is the
deleted residual divided by its estimated standard deviation. Studentized
residuals are going to be more effective for detecting outlying Y
observations than standardized residuals. If an observation has an externally
studentized residual that is larger than 3 (in absolute value) we can call
it an outlier.
}
\section{Deprecated Function}{

\code{ols_srsd_plot()} has been deprecated. Instead use \code{ols_plot_resid_stud()}.
}

\examples{
model <- lm(mpg ~ disp + hp + wt, data = mtcars)
ols_plot_resid_stud(model)

}
\seealso{
[ols_plot_resid_stand()]
}
