% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odbc-connection.R
\name{odbcConnectionTables}
\alias{odbcConnectionTables}
\alias{odbcConnectionTables,OdbcConnection,Id-method}
\alias{odbcConnectionTables,OdbcConnection,character-method}
\alias{odbcConnectionTables,OdbcConnection,ANY-method}
\alias{odbcConnectionTables,OdbcConnection,SQL-method}
\title{odbcConnectionTables}
\usage{
odbcConnectionTables(conn, name, ...)

\S4method{odbcConnectionTables}{OdbcConnection,Id}(conn, name, table_type = NULL, exact = FALSE)

\S4method{odbcConnectionTables}{OdbcConnection,character}(
  conn,
  name,
  catalog_name = NULL,
  schema_name = NULL,
  table_type = NULL,
  exact = FALSE
)

\S4method{odbcConnectionTables}{OdbcConnection,ANY}(
  conn,
  name = NULL,
  catalog_name = NULL,
  schema_name = NULL,
  table_type = NULL,
  exact = FALSE
)

\S4method{odbcConnectionTables}{OdbcConnection,SQL}(conn, name, table_type = NULL, exact = FALSE)
}
\arguments{
\item{conn}{OdbcConnection}

\item{name, catalog_name, schema_name}{Catalog, schema, and table identifiers.
By default, are interpreted as a ODBC search pattern where \verb{_} and \verb{\%} are
wild cards. Set \code{exact = TRUE} to match \verb{_} exactly.}

\item{...}{additional parameters to methods}

\item{table_type}{List tables of this type, for example 'VIEW'.
See odbcConnectionTableTypes for a listing of available table
types for your connection.}

\item{exact}{Set to \code{TRUE} to escape \verb{_} in identifier names so that it
matches exactly, rather than matching any single character. \verb{\%} always
matches any number of characters as this is unlikely to appear in a
table name.}
}
\value{
data.frame with columns
\itemize{
\item table_catalog
\item table_schema
\item table_name
\item table_remarks
}
}
\description{
This function returns a listing of tables accessible
to the connected user.
The expectation is that this is a relatively thin
wrapper around the ODBC \code{SQLTables} function call,
albeit returning a subset of the fields.
}
\details{
It is important to note that, similar to the ODBC/API
call, this method also accomodates pattern-value arguments
for the catalog, schema, and table name arguments.

If extending this method, be aware that \code{package:odbc}
internally uses this method to satisfy both
DBI::dbListTables and DBI::dbExistsTable methods.
( The former also advertises pattern value arguments )
}
\seealso{
The ODBC documentation on
\href{https://docs.microsoft.com/en-us/sql/odbc/reference/syntax/sqlcolumns-function}{SQLTables}
for further details.
}
