% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_audio.R
\name{audio_translation_request}
\alias{audio_translation_request}
\title{API audio: translate audio file into English text}
\usage{
audio_translation_request(
  file,
  model,
  prompt = NULL,
  response_format = NULL,
  temperature = NULL,
  api_key = api_get_key()
)
}
\arguments{
\item{file}{string/raw, content of the input audio file or path to the input audio file to translate, in one of these
formats: flac, mp3, mp4, mpeg, mpga, m4a, ogg, wav, or webm}

\item{model}{string, ID of the model to use. Only 'whisper-1' is currently available.}

\item{prompt}{string, An optional text to guide the model's style or continue a previous audio segment. The prompt
should be in English.}

\item{response_format}{string, the format of the transcript output, in one of these options: json (default), text,
srt, verbose_json, or vtt.}

\item{temperature}{double, the sampling temperature, between 0 and 1. Higher values like 0.8 will make the output
more random, while lower values like 0.2 will make it more focused and deterministic. If set to 0, the model will use
log probability to automatically increase the temperature until certain thresholds are hit. 0 is default.}

\item{api_key}{string, OpenAI API key
(see https://platform.openai.com/account/api-keys)}
}
\value{
\link[httr]{content} of the httr \link[httr]{response} object
or SimpleError (\link[base]{conditions}) enhanced with
two additional fields: `status_code` (response$status_code)
and `message_long` (built on response content)
}
\description{
Translates audio into English. To get more details, visit
https://platform.openai.com/docs/api-reference/audio/createTranslation
https://platform.openai.com/docs/guides/speech-to-text
}
\examples{
\dontrun{
res_content <- audio_translation_request(
  "path/to/audio/file.mp3",
  "whisper-1",
  response_format = "text"
)
if (!is_error(res_content)) {
  message(res_content)
}
}

}
