% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmfbin.R
\name{nmfbin}
\alias{nmfbin}
\title{Logistic Non-negative Matrix Factorization}
\usage{
nmfbin(
  X,
  k,
  optimizer = "mur",
  init = "nndsvd",
  max_iter = 1000,
  tol = 1e-06,
  learning_rate = 0.001,
  verbose = FALSE,
  loss_fun = "logloss",
  loss_normalize = TRUE,
  epsilon = 1e-10
)
}
\arguments{
\item{X}{A binary matrix (m x n) to be factorized.}

\item{k}{The number of factors (components, topics).}

\item{optimizer}{Type of updating algorithm. \code{mur} for NMF multiplicative update rules, \code{gradient} for gradient descent, \code{sgd} for stochastic gradient descent.}

\item{init}{Method for initializing the factorization. By default Nonnegative Double Singular Value Decomposition with average densification.}

\item{max_iter}{Maximum number of iterations for optimization.}

\item{tol}{Convergence tolerance. The optimization stops when the change in loss is less than this value.}

\item{learning_rate}{Learning rate (step size) for the gradient descent optimization.}

\item{verbose}{Print convergence if \code{TRUE}.}

\item{loss_fun}{Choice of loss function: \code{logloss} (negative log-likelihood, also known as binary cross-entropy) or \code{mse} (mean squared error).}

\item{loss_normalize}{Normalize loss by matrix dimensions if \code{TRUE}.}

\item{epsilon}{Constant to avoid log(0).}
}
\value{
A list containing:
\itemize{
\item \code{W}: The basis matrix (m x k). The document-topic matrix in topic modelling.
\item \code{H}: The coefficient matrix (k x n). Contribution of features to factors (topics).
\item \code{c}: The global threshold. A constant.
\item \code{convergence}: Divergence (loss) from \code{X} at every \code{iter} until \code{tol} or \code{max_iter} is reached.
}
}
\description{
This function performs Logistic Non-negative Matrix Factorization (NMF) on a binary matrix.
}
\examples{
# Generate a binary matrix
m <- 100
n <- 50
X <- matrix(sample(c(0, 1), m * n, replace = TRUE), m, n)

# Set the number of factors
k <- 4

# Factorize the matrix with default settings
result <- nmfbin(X, k)
}
