% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimize.R
\name{optimize}
\alias{optimize}
\title{Optimizes the problem}
\usage{
optimize(solver, file, options)
}
\arguments{
\item{solver}{name of the solver (it has to be in the PATH)}

\item{file}{.nl file with the optimization problem. If the name of the file starts with MINLPLib:: then the problem will be downloaded from MINLPLib library}

\item{options}{list with the options for the solver}
}
\value{
list with a string of the output given by the solver (output), the optimal value of the problem (objective), the status returned by the solver (status), the optimal primal solution (primal_solution), and the optimal dual solution (dual_solution)
}
\description{
Function that calls the corresponding solver with custom options to solve the problem given by the .nl file
}
\examples{
optimize(solver = "ipopt", file = "MINLPLib::alkyl", options=list(max_cpu_time=300, outlev=3))

}
