% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbernppAC.R
\name{dbernppAC}
\alias{dbernppAC}
\alias{rbernppAC}
\title{Bernoulli point process for the distribution of activity centers}
\usage{
dbernppAC(
  x,
  lowerCoords,
  upperCoords,
  logIntensities,
  logSumIntensity,
  habitatGrid,
  numGridRows,
  numGridCols,
  log = 0
)

rbernppAC(
  n,
  lowerCoords,
  upperCoords,
  logIntensities,
  logSumIntensity,
  habitatGrid,
  numGridRows,
  numGridCols
)
}
\arguments{
\item{x}{Vector of x- and y-coordinates of a single spatial point (i.e. AC location) scaled to the habitat (see (\code{\link{scaleCoordsToHabitatGrid}}).}

\item{lowerCoords, upperCoords}{Matrices of lower and upper x- and y-coordinates of all habitat windows scaled to the habitat (see (\code{\link{scaleCoordsToHabitatGrid}}). One row for each window. 
Each window should be of size 1x1.}

\item{logIntensities}{Vector of log habitat intensities for all habitat windows.}

\item{logSumIntensity}{Log of the sum of habitat intensities over all windows.}

\item{habitatGrid}{Matrix of habitat window indices. Cell values should correspond to the order of habitat windows in
\code{lowerCoords}, \code{upperCoords}, and \code{logIntensities}. 
When the habitat grid only consists of a single row or column of windows, an additional row or column of dummy indices has to be added because the \code{nimble} model code requires a matrix.}

\item{numGridRows, numGridCols}{Numbers of rows and columns of the habitat grid.}

\item{log}{Logical argument, specifying whether to return the log-probability of the distribution.}

\item{n}{Integer specifying the number of realisations to generate.  Only n = 1 is supported.}
}
\value{
\code{dbernppAC} gives the (log) probability density of the observation vector \code{x}. 
\code{rbernppAC} gives coordinates of a randomly generated spatial point.
}
\description{
Density and random generation functions of the Bernoulli point process for the distribution of activity centers.
}
\details{
The \code{dbernppAC} distribution is a NIMBLE custom distribution which can be used to model and simulate
the activity center location (\emph{x}) of a single individual in continuous space over a set of habitat windows defined by their upper and lower
coordinates (\emph{lowerCoords,upperCoords}). The distribution assumes that the activity center  
follows a Bernoulli point process with intensity = \emph{exp(logIntensities)}.
}
\examples{
# Use the distribution in R
lowerCoords <- matrix(c(0, 0, 1, 0, 0, 1, 1, 1), nrow = 4, byrow = TRUE)
upperCoords <- matrix(c(1, 1, 2, 1, 1, 2, 2, 2), nrow = 4, byrow = TRUE)  
logIntensities <- log(c(1:4))
logSumIntensity <- log(sum(c(1:4)))  
habitatGrid <- matrix(c(1:4), nrow = 2, byrow = TRUE)
numGridRows <- nrow(habitatGrid)
numGridCols <- ncol(habitatGrid)
dbernppAC(c(0.5, 1.5), lowerCoords, upperCoords, logIntensities, logSumIntensity, 
          habitatGrid, numGridRows, numGridCols, log = TRUE)
}
\references{
W. Zhang, J. D. Chipperfield, J. B. Illian, P. Dupont, C. Milleret, P. de Valpine and R. Bischof. 2020. 
A hierarchical point process model for spatial capture-recapture data. bioRxiv. DOI 10.1101/2020.10.06.325035
}
\author{
Wei Zhang
}
