% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assort.R
\name{assort}
\alias{assort}
\alias{assort.table}
\alias{assort.igraph}
\alias{assort.default}
\title{Assortativity Coefficient}
\usage{
assort(object, ...)

\method{assort}{table}(object, ...)

\method{assort}{igraph}(object, vattr, ...)

\method{assort}{default}(object, ...)
}
\arguments{
\item{object}{R object, see available methods}

\item{...}{other arguments to/from other methods}

\item{vattr}{character, name of the vertex attribute for which the measure is
to be calculated}
}
\value{
Numeric value of the index.
}
\description{
Assortativity coefficient is a measure of segregation for social networks
due to Newman & Girvan (2002).
}
\details{
The measure evaluates the relative prevalence of within-group ties. It is
based on the contact layer of the mixing matrix.

Assortativity coefficient is 1 if all ties are within-group.
The minimum can be negative, but not less than -1, and depends on the
relative number of ties of nodes in different groups. If the network
conforms to "proportionate mixing", the coefficient is 0.

If \code{object} is a table it is interpreted as a mixing matrix.
Two-dimensional table is interpreted as a contact layer. Three-dimensional
table is interpreted as a full mixing matrix \eqn{m_{ghy}}{m[ghy]}
cross-classyfying all dyads, in which \eqn{g} and \eqn{h} correspond to
group membership of ego and alter respectively. Layers \eqn{y=1} and
\eqn{y=2} are assumed to be non-contact and contact layers respectively.

If \code{object} is of class "igraph" it is required to supply \code{vattr}
with the name of the vertex attribute to calculate intermediate mixing
matrix.

For any other classes, \code{object} is coerced to a table and the table
method is called.
}
\examples{
assort(WhiteKinship, "gender")
assort(EF3, "type")

# Values of `assort()` for full networks of different sizes
if( requireNamespace("igraph", quietly = TRUE) ) {
  f <- function(n) {
    gfull <- igraph::make_full_graph(n, directed=FALSE)
    igraph::V(gfull)$type <- rep(1:2, length = igraph::vcount(gfull))
    assort(gfull, "type")
  }
  set.seed(1)
  x <- sort(sample(5:100, 25) * 2)
  y <- sapply(x, f)
  plot(x, y, type="o",
       xlab="Network size", ylab="Assortativity coefficient",
       main="Assortativity coef. for full networks of different sizes")
}
}
\references{
Newman, M. J. and Girvan, M. (2002) "Mixing patterns and
community structure in networks", arXiv:cond-mat/0210146v1

Newman, M. J. (2003) "Mixing patterns in networks" arXiv:cond-mat/0209450v2
}
\seealso{
Mixing matrices: \code{\link[=mixingm]{mixingm()}}

Other segregation measures: 
\code{\link{coleman}()},
\code{\link{ei}()},
\code{\link{freeman}()},
\code{\link{gamix}()},
\code{\link{orwg}()},
\code{\link{smi}()},
\code{\link{ssi}()}
}
\concept{segregation measures}
