% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nestfs.R
\name{nested.fs}
\alias{nested.fs}
\alias{nested.forward.selection}
\title{Nested cross-validated forward selection}
\usage{
nested.fs(formula, data, family, folds, ...)

nested.forward.selection(x, y, init.model, family, folds, ...)
}
\arguments{
\item{formula}{An object of class \code{formula} (or one that can be coerced to
that class) that describes the baseline model to be fitted.}

\item{data}{Data frame or matrix containing outcome variable and predictors.}

\item{family}{Type of model fitted: either \code{gaussian()} for linear regression
or \code{binomial()} for logistic regression. This can be specified also as
a function name (\code{gaussian}) or as a string (\code{"gaussian"}).}

\item{folds}{List of cross-validation folds, where each element contains
the indices of the observations to be withdrawn in that fold.}

\item{...}{Arguments to \code{\link[=fs]{fs()}}.}

\item{x}{Dataframe of predictors: this should include all variables in
the initial set and the variables that are allowed to enter the
selected panel.}

\item{y}{Outcome variable. If \code{family=binomial}, it can only contain
two classes of values that can be coerced to 0-1.}

\item{init.model}{Either a formula or a vector of names of the initial set
of variables that define the model from which the forward selection
should start.}
}
\value{
An object of class \code{nestfs} of length equal to \code{length(folds)}, where each
element is an object of class \code{fs} containing the following additional fields:
\item{fit}{Predicted values for the withdrawn observations.}
\item{obs}{Observed values for the withdrawn observations.}
\item{test.idx}{Indices of the the withdrawn observations for this fold.}
\item{model}{Summary of the model built using the selected panel.}
}
\description{
Run nested forward selection starting from a set of variables or a model.
}
\details{
This function allows to obtain an unbiased estimate of the performance
of the selected panels on withdrawn data by running forward selection on
a predetermined set of folds.

\code{nested.forward.selection} provides the legacy interface used up to version
0.9.2. It is considered discontinued, and in the future it will be deprecated
and eventually removed.
}
\examples{
\dontshow{oldopts <- options(mc.cores=2)}
data(diabetes)
folds <- create.folds(2, nrow(diabetes), seed=1)
nestfs.res <- nested.fs(Y ~ age + sex, diabetes, gaussian(), folds,
                        choose.from=1:10, num.inner.folds=5, max.iters=3)
summary(nestfs.res)
\dontshow{options(oldopts)}

}
\seealso{
\code{\link[=fs]{fs()}}, \code{\link[=summary.nestfs]{summary.nestfs()}} and \code{\link[=nested.performance]{nested.performance()}}.
}
\keyword{multivariate}
