Contributing to the ncmeta R package
===================================

You want to contribute to **ncmeta**? Great!

Please submit questions, bug reports, and requests in the [issues
tracker](https://github.com/hypertidy/ncmeta/issues). Please submit
bug reports with a minimal [reprex](https://www.tidyverse.org/help/#reprex).

If you plan to contribute code, go ahead and fork the repo and submit a pull
request. A few notes:

-   This package is released with a [Contributor Code of
    Conduct](CODE_OF_CONDUCT.md). By participating in this project you agree to
    abide by its terms. Why? We want contribution to be enjoyable and rewarding
    for everyone!
-   I'm avoiding dependencies on unrelated libs, such as [GDAL](https://gdal.org/) which 
    means no use of rgdal, sf, or vapour. This is a package for [NetCDF sources](https://www.unidata.ucar.edu/software/netcdf/)
    and GDAL has its own support for this format that is completely independent. 
-   If you have a large change, please open an issue first to discuss.
-   I'll generally include contributors as authors in the DESCRIPTION file for most 
    contributions that go beyond small typos in code or documentation. Please
    let me know if you **do not** want your contribution included that way. 
-   This package generally uses the [rOpenSci packaging
    guidelines](https://ropensci.github.io/dev_guide/) for style and structure.
-   Documentation is generated by **roxygen2**. Please write documentation in
    code files and let it auto-generate documentation files. We use a recent
    version so documentation my be [written in
    markdown](https://cran.r-project.org/web/packages/roxygen2/vignettes/markdown.html)


