% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aio.R
\name{send_aio}
\alias{send_aio}
\title{Send Async}
\usage{
send_aio(con, data, mode = c("serial", "raw", "next"), timeout = NULL)
}
\arguments{
\item{con}{a Socket, Context or Stream.}

\item{data}{an object (a vector, if mode = 'raw').}

\item{mode}{[default 'serial'] one of 'serial' to send serialised R objects,
'raw' to send atomic vectors of any type as a raw byte vector, or 'next'
(see 'Send Modes' section below). Alternatively, specify an integer
position in the vector of choices e.g. 1L for 'serial' or 2L for 'raw'
etc. For Streams, 'raw' is the only option and this argument is ignored.}

\item{timeout}{[default NULL] integer value in milliseconds or NULL, which
applies a socket-specific default, usually the same as no timeout.}
}
\value{
A 'sendAio' (object of class 'sendAio') (invisibly).
}
\description{
Send data asynchronously over a connection (Socket, Context or Stream).
}
\details{
Async send is always non-blocking and returns a 'sendAio'
    immediately.

    For a 'sendAio', the send result is available at \code{$result}. An
    'unresolved' logical NA is returned if the async operation is yet to
    complete. The resolved value will be zero on success, or else an integer
    error code.

    To wait for and check the result of the send operation, use
    \code{\link{call_aio}} on the returned 'sendAio' object.

    Alternatively, to stop the async operation, use \code{\link{stop_aio}}.
}
\section{Send Modes}{


    The default mode 'serial' sends serialised R objects to ensure perfect
    reproducibility within R. When receiving, the corresponding mode 'serial'
    should be used.

    Mode 'raw' sends atomic vectors of any type as a raw byte vector, and
    must be used when interfacing with external applications or raw system
    sockets, where R serialization is not in use. When receiving, the mode
    corresponding to the vector sent should be used.

    Mode 'next' sends serialised R objects, with native extensions enabled by
    \code{\link{next_config}}. This configures custom serialization and
    unserialization functions for external pointer type objects. When
    receiving, mode 'serial' should be used as 'next' sends are fully
    compatible.
}

\examples{
pub <- socket("pub", dial = "inproc://nanonext")

res <- send_aio(pub, data.frame(a = 1, b = 2), timeout = 100)
res
res$result

res <- send_aio(pub, "example message", mode = "raw", timeout = 100)
call_aio(res)$result

close(pub)

}
