% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ndmm_ipd}
\alias{ndmm_ipd}
\alias{ndmm_agd}
\alias{ndmm_agd_covs}
\title{Newly diagnosed multiple myeloma}
\format{
The individual patient data are contained in a data frame \code{ndmm_ipd}
with 1325 rows, one per individual, and 10 variables:
\describe{
\item{study, studyf}{study name}
\item{trt, trtf}{treatment name}
\item{eventtime}{event/censoring time}
\item{status}{censoring indicator (0 = censored, 1 = event)}
\item{age}{age (years)}
\item{iss_stage3}{ISS stage 3 (0 = no, 1 = yes)}
\item{response_cr_vgpr}{complete or very good partial response (0 = no, 1 = yes)}
\item{male}{male sex (0 = no, 1 = yes)}
}

The reconstructed Kaplan-Meier data for the aggregate studies are
contained in a data frame \code{ndmm_agd} with 2819 rows and 6 variables:
\describe{
\item{study, studyf}{study name}
\item{trt, trtf}{treatment name}
\item{eventtime}{event/censoring time}
\item{status}{censoring indicator (0 = censored, 1 = event)}
}

The covariate summaries extracted from published reportes for the
aggregate studies are contained in a data frame \code{ndmm_agd_covs} with 4
rows, one per study arm, and 15 columns:
\describe{
\item{study, studyf}{study name}
\item{trt, trtf}{treatment name}
\item{sample_size}{sample size in each arm}
\item{age_min, age_iqr_l, age_median, age_iqr_h, age_max, age_mean, age_sd}{summary statistics for age (years)}
\item{iss_stage3}{proportion of participants with ISS stage 3}
\item{response_cr_vgpr}{proportion of participants with complete or very good partial response}
\item{male}{proportion of male participants}
}
}
\usage{
ndmm_ipd

ndmm_agd

ndmm_agd_covs
}
\description{
Three data frames, \code{ndmm_ipd}, \code{ndmm_agd}, and \code{ndmm_agd_covs} containing
(simulated) individual patient data (IPD) from three studies and aggregate
data (AgD) from two studies on newly diagnosed multiple myeloma. The outcome
of interest is progression-free survival after autologous stem cell
transplant. The IPD studies in \code{ndmm_ipd} provide event/censoring times and
covariate values for each individual. The AgD studies provide reconstructed
event/censoring times from digitized Kaplan-Meier curves in \code{ndmm_agd} and
covariate summaries in \code{ndmm_agd_covs}, obtained from published trial
reports. The data are constructed to resemble those used by
\insertCite{Leahy2019;textual}{multinma}.
}
\references{
\insertAllCited{}
}
\keyword{datasets}
