% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nested-modeltime_select_best.R
\name{modeltime_nested_select_best}
\alias{modeltime_nested_select_best}
\title{Select the Best Models from Nested Modeltime Table}
\usage{
modeltime_nested_select_best(
  object,
  metric = "rmse",
  minimize = TRUE,
  filter_test_forecasts = TRUE
)
}
\arguments{
\item{object}{A Nested Modeltime Table}

\item{metric}{A metric to minimize or maximize. By default available metrics are:
\itemize{
\item "rmse" (default)
\item "mae"
\item "mape"
\item "mase"
\item "smape"
\item "rsq"
}}

\item{minimize}{Whether to minimize or maximize. Default: TRUE (minimize).}

\item{filter_test_forecasts}{Whether or not to update the test forecast log to
filter only the best forecasts. Default: TRUE.}
}
\description{
Finds the best models for each time series group in a Nested Modeltime Table using
a \code{metric} that the user specifies.
\itemize{
\item Logs the best results, which can be accessed with \code{\link[=extract_nested_best_model_report]{extract_nested_best_model_report()}}
\item If \code{filter_test_forecasts = TRUE}, updates the test forecast log, which can be accessed
\code{\link[=extract_nested_test_forecast]{extract_nested_test_forecast()}}
}
}
