% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multNormTest.R
\name{test.DEHU}
\alias{test.DEHU}
\title{Doerr-Ebner-Henze test of multivariate normality based on a double estimation in a PDE}
\usage{
test.DEHU(data, a = 0.5, MC.rep = 10000, alpha = 0.05)
}
\arguments{
\item{data}{a n x d matrix of d dimensional data vectors.}

\item{a}{positive numeric number (tuning parameter).}

\item{MC.rep}{number of repetitions for the Monte Carlo simulation of the critical value.}

\item{alpha}{level of significance of the test.}
}
\value{
a list containing the value of the test statistic, the approximated critical value and a test decision on the significance level \code{alpha}: \cr
\describe{
        \item{\code{$Test}}{name of the test.}
        \item{\code{$param}}{value tuning parameter.}
        \item{\code{$Test.value}}{the value of the test statistic.}
        \item{\code{$cv}}{the approximated critical value.}
        \item{\code{$Decision}}{the comparison of the critical value and the value of the test statistic.}
}
}
\description{
Computes the multivariate normality test of Doerr, Ebner and Henze (2019) based on a double estimation in a PDE.
}
\details{
This functions evaluates the teststatistic with the given data and the specified tuning parameter \code{a}.
Each row of the data Matrix contains one of the n (multivariate) sample with dimension d. To ensure that the computation works properly
\eqn{n \ge d+1} is needed. If that is not the case the test returns an error.
}
\examples{
test.DEHU(MASS::mvrnorm(50,c(0,1),diag(1,2)),a=1,MC=500)

}
\references{
Doerr, P., Ebner, B., Henze, N. (2019) "Testing multivariate normality by zeros of the harmonic oscillator in characteristic function spaces" \href{https://arxiv.org/abs/1909.12624}{arXiv:1909.12624}
}
\seealso{
\code{\link{DEHU}}
}
