% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeMBOControl.R
\name{makeMBOControl}
\alias{makeMBOControl}
\alias{MBOControl}
\title{Set MBO options.}
\usage{
makeMBOControl(
  n.objectives = 1L,
  propose.points = 1L,
  final.method = "best.true.y",
  final.evals = 0L,
  y.name = "y",
  impute.y.fun = NULL,
  trafo.y.fun = NULL,
  suppress.eval.errors = TRUE,
  save.on.disk.at = integer(0L),
  save.on.disk.at.time = Inf,
  save.file.path = file.path(getwd(), "mlrMBO_run.RData"),
  store.model.at = NULL,
  resample.at = integer(0),
  resample.desc = makeResampleDesc("CV", iter = 10),
  resample.measures = list(mse),
  output.num.format = "\%.3g",
  on.surrogate.error = "stop"
)
}
\arguments{
\item{n.objectives}{[\code{integer(1)}]\cr
How many objectives are to be optimized? \code{n.objectives = 1} implies normal single
criteria optimization, \code{n.objectives > 1} implies multi-objective optimization.
Default is 1.}

\item{propose.points}{[\code{integer(1)}]\cr
Number of proposed / really evaluated points each iteration.
Default is 1.}

\item{final.method}{[\code{character(1)}]\cr
How should the final point be proposed. Possible values are:
\dQuote{best.true.y}: Return best point ever visited according to true value of target function.
Can be bad if target function is noisy.
\dQuote{last.proposed}: Return the last point proposed by the model.
\dQuote{best.predicted}: Use the final model to predict all points ever visited and use the best one.
This might average-out noisy function values.
Default is: \dQuote{best.true.y}.}

\item{final.evals}{[\code{integer(1)}]\cr
How many target function evals should be done at final point to reduce noise?
Default is 0.}

\item{y.name}{[\code{character}]\cr
Vector for names of y-columns for target values in optimization path.
Default is \dQuote{y_i}, i = 1, ..., n.objectives.}

\item{impute.y.fun}{[\code{function(x, y, opt.path, ...)}*]\cr
Functions that gets triggered if your objective evaluation produced
a) an exception b) a return object of invalid type c) a numeric vector that
contains \code{NA}, \code{NaN}, \code{Inf}.
You now have a chance to handle this. You are expected to return a numeric vector
of the correct length with concrete values.
The optimization path will show some information whether y-values where imputed
and what the original, faulty object was.
\code{x} is the current x-value, \code{y} the current (invalid) y-object (or an error object)
and \code{opt.path} the current optimization path.
Default is \code{NULL} which means to stop if the objective function did not produce the desired
result.}

\item{trafo.y.fun}{[\code{MBOTrafoFunction}]\cr
Sometimes it is favorable to transform the target function values before modeling. Provide a
MBO transformation function to do so.}

\item{suppress.eval.errors}{[\code{logical(1)}]\cr
Should reporting of error messages during target function evaluations be suppressed?
Only used if \code{impute.errors} is \code{TRUE}.
Default is \code{TRUE}.}

\item{save.on.disk.at}{[\code{integer}] \cr
Sequential optimization iteration when the actual state should be saved
on disk. Iteration 0 denotes the initial design. If the optimization
stops with an crucial error, it can be restarted with this file via the
function \code{\link{mboContinue}}.
Default is \code{integer(0L)}, i. e., not to save.}

\item{save.on.disk.at.time}{[\code{integer}] \cr
Same as above. But here you define the time which have to be passed until the last save in seconds. Any finite value will lead to save at end.
Default is \code{Inf}, i. e., not to save ever.}

\item{save.file.path}{[\code{character(1)}] \cr
If \code{save.on.disk.at} is used, this is the name of the file where the data
will be saved.
Default \dQuote{mbo_run.RData} in your current working directory.}

\item{store.model.at}{[\code{integer}]\cr
Sequential optimization iterations when the model should be saved.
Iteration 1 is the model fit for the initial design, iters + 1 is a final
save containing the final results of the optimization. .
Default is \code{iters + 1}.}

\item{resample.at}{[\code{integer}]\cr
At which iterations should the model be resampled and assessed?
Iteration 0 does some resampling on the initial design.
Default is none.}

\item{resample.desc}{[\code{\link[mlr]{ResampleDesc}}]\cr
How should the model be resampled?
Default is 10-fold CV.}

\item{resample.measures}{[list of \code{\link[mlr]{Measure}}]\cr
Performance measures to assess model with during resampling.
Default is \code{\link[mlr]{mse}}.}

\item{output.num.format}{[\code{logical(1)}]\cr
Format string for the precision of the numeric output of mbo.}

\item{on.surrogate.error}{[\code{character(1)}]\cr
What should happen when the surrogate learner can not train the model.
Possible values are:
\dQuote{stop}: R exception is generated.
\dQuote{warn}: The error will be converted to a waring and a random point will be proposed.
\dQuote{quiet}: Same as “warn” but without the warning.
This will overwrite the mlr setting \code{on.learner.error} for the surrogate learner.
Default is: \dQuote{stop}.}
}
\value{
[\code{\link{MBOControl}}].
}
\description{
Creates a control object for MBO optimization.
}
\seealso{
Other MBOControl: 
\code{\link{setMBOControlInfill}()},
\code{\link{setMBOControlMultiObj}()},
\code{\link{setMBOControlMultiPoint}()},
\code{\link{setMBOControlTermination}()}
}
\concept{MBOControl}
