% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpProxy.R
\name{mlr_pipeops_proxy}
\alias{mlr_pipeops_proxy}
\alias{PipeOpProxy}
\title{Wrap another PipeOp or Graph as a Hyperparameter}
\format{
Abstract \code{\link[R6:R6Class]{R6Class}} inheriting from \code{\link{PipeOp}}.
}
\description{
Wraps another \code{\link{PipeOp}} or \code{\link{Graph}} as determined by the \code{content} hyperparameter.
Input is routed through the \code{content} and the \code{content}s' output is returned.
The \code{content} hyperparameter can be changed during tuning, this is useful as an alternative to \code{\link{PipeOpBranch}}.
}
\section{Construction}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{PipeOpProxy$new(innum = 0, outnum = 1, id = "proxy", param_vals = list())
}\if{html}{\out{</div>}}
\itemize{
\item \code{innum} :: \verb{numeric(1)\\cr Determines the number of input channels. If }innum` is 0 (default), a vararg input channel is created that can take an arbitrary number of inputs.
\item \code{outnum} :: `numeric(1)\cr
Determines the number of output channels.
\item \code{id} :: \code{character(1)}\cr
Identifier of resulting object. See \verb{$id} slot of \code{\link{PipeOp}}.
\item \code{param_vals} :: named \code{list}\cr
List of hyperparameter settings, overwriting the hyperparameter settings that would otherwise
be set during construction. Default \code{list()}.
}
}

\section{Input and Output Channels}{

\code{\link{PipeOpProxy}} has multiple input channels depending on the \code{innum} construction argument, named
\code{"input1"}, \code{"input2"}, ... if \code{innum} is nonzero; if \code{innum} is 0, there is only one \emph{vararg}
input channel named \code{"..."}.

\code{\link{PipeOpProxy}} has multiple output channels depending on the \code{outnum} construction argument,
named \code{"output1"}, \code{"output2"}, ...
The output is determined by the output of the \code{content} operation (a \code{\link{PipeOp}} or \code{\link{Graph}}).
}

\section{State}{

The \verb{$state} is the trained \code{content} \code{\link{PipeOp}} or \code{\link{Graph}}.
}

\section{Parameters}{

\itemize{
\item \code{content} :: \code{\link{PipeOp}} | \code{\link{Graph}}\cr
The \code{\link{PipeOp}} or \code{\link{Graph}} that is being proxied (or an object that is
converted to a \code{\link{Graph}} by \code{\link[=as_graph]{as_graph()}}). Defaults to an instance of
\code{\link{PipeOpFeatureUnion}} (combines all input if they are \code{\link[mlr3:Task]{Task}}s).
}
}

\section{Internals}{

The \code{content} will internally be coerced to a graph via
\code{\link[=as_graph]{as_graph()}} prior to train and predict.

The default value for \code{content} is \code{\link{PipeOpFeatureUnion}},
}

\section{Fields}{

Fields inherited from \code{\link{PipeOp}}.
}

\section{Methods}{

Only methods inherited from \code{\link{PipeOp}}.
}

\examples{
\dontshow{ if (requireNamespace("rpart")) \{ }
library("mlr3")
library("mlr3learners")

set.seed(1234)
task = tsk("iris")

# use a proxy for preprocessing and a proxy for learning, i.e.,
# no preprocessing and classif.kknn
g = po("proxy", id = "preproc", param_vals = list(content = po("nop"))) \%>>\%
  po("proxy", id = "learner", param_vals = list(content = lrn("classif.kknn")))
rr_kknn = resample(task, learner = GraphLearner$new(g), resampling = rsmp("cv", folds = 3))
rr_kknn$aggregate(msr("classif.ce"))

# use pca for preprocessing and classif.rpart as the learner
g$param_set$values$preproc.content = po("pca")
g$param_set$values$learner.content = lrn("classif.rpart")
rr_pca_rpart = resample(task, learner = GraphLearner$new(g), resampling = rsmp("cv", folds = 3))
rr_pca_rpart$aggregate(msr("classif.ce"))
\dontshow{ \} }
}
\seealso{
https://mlr-org.com/pipeops.html

Other PipeOps: 
\code{\link{PipeOp}},
\code{\link{PipeOpEnsemble}},
\code{\link{PipeOpImpute}},
\code{\link{PipeOpTargetTrafo}},
\code{\link{PipeOpTaskPreproc}},
\code{\link{PipeOpTaskPreprocSimple}},
\code{\link{mlr_pipeops}},
\code{\link{mlr_pipeops_boxcox}},
\code{\link{mlr_pipeops_branch}},
\code{\link{mlr_pipeops_chunk}},
\code{\link{mlr_pipeops_classbalancing}},
\code{\link{mlr_pipeops_classifavg}},
\code{\link{mlr_pipeops_classweights}},
\code{\link{mlr_pipeops_colapply}},
\code{\link{mlr_pipeops_collapsefactors}},
\code{\link{mlr_pipeops_colroles}},
\code{\link{mlr_pipeops_copy}},
\code{\link{mlr_pipeops_datefeatures}},
\code{\link{mlr_pipeops_encode}},
\code{\link{mlr_pipeops_encodeimpact}},
\code{\link{mlr_pipeops_encodelmer}},
\code{\link{mlr_pipeops_featureunion}},
\code{\link{mlr_pipeops_filter}},
\code{\link{mlr_pipeops_fixfactors}},
\code{\link{mlr_pipeops_histbin}},
\code{\link{mlr_pipeops_ica}},
\code{\link{mlr_pipeops_imputeconstant}},
\code{\link{mlr_pipeops_imputehist}},
\code{\link{mlr_pipeops_imputelearner}},
\code{\link{mlr_pipeops_imputemean}},
\code{\link{mlr_pipeops_imputemedian}},
\code{\link{mlr_pipeops_imputemode}},
\code{\link{mlr_pipeops_imputeoor}},
\code{\link{mlr_pipeops_imputesample}},
\code{\link{mlr_pipeops_kernelpca}},
\code{\link{mlr_pipeops_learner}},
\code{\link{mlr_pipeops_missind}},
\code{\link{mlr_pipeops_modelmatrix}},
\code{\link{mlr_pipeops_multiplicityexply}},
\code{\link{mlr_pipeops_multiplicityimply}},
\code{\link{mlr_pipeops_mutate}},
\code{\link{mlr_pipeops_nmf}},
\code{\link{mlr_pipeops_nop}},
\code{\link{mlr_pipeops_ovrsplit}},
\code{\link{mlr_pipeops_ovrunite}},
\code{\link{mlr_pipeops_pca}},
\code{\link{mlr_pipeops_quantilebin}},
\code{\link{mlr_pipeops_randomprojection}},
\code{\link{mlr_pipeops_randomresponse}},
\code{\link{mlr_pipeops_regravg}},
\code{\link{mlr_pipeops_removeconstants}},
\code{\link{mlr_pipeops_renamecolumns}},
\code{\link{mlr_pipeops_replicate}},
\code{\link{mlr_pipeops_scale}},
\code{\link{mlr_pipeops_scalemaxabs}},
\code{\link{mlr_pipeops_scalerange}},
\code{\link{mlr_pipeops_select}},
\code{\link{mlr_pipeops_smote}},
\code{\link{mlr_pipeops_spatialsign}},
\code{\link{mlr_pipeops_subsample}},
\code{\link{mlr_pipeops_targetinvert}},
\code{\link{mlr_pipeops_targetmutate}},
\code{\link{mlr_pipeops_targettrafoscalerange}},
\code{\link{mlr_pipeops_textvectorizer}},
\code{\link{mlr_pipeops_threshold}},
\code{\link{mlr_pipeops_tunethreshold}},
\code{\link{mlr_pipeops_unbranch}},
\code{\link{mlr_pipeops_updatetarget}},
\code{\link{mlr_pipeops_vtreat}},
\code{\link{mlr_pipeops_yeojohnson}}
}
\concept{PipeOps}
