% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune.R
\name{tune}
\alias{tune}
\title{Wrapper function to tune pls-derived methods.}
\usage{
tune(
  method = c("spls", "splsda", "mint.splsda", "rcc", "pca", "spca"),
  X,
  Y,
  multilevel = NULL,
  ncomp,
  study,
  test.keepX = c(5, 10, 15),
  test.keepY = NULL,
  already.tested.X,
  already.tested.Y,
  mode = c("regression", "canonical", "invariant", "classic"),
  nrepeat = 1,
  grid1 = seq(0.001, 1, length = 5),
  grid2 = seq(0.001, 1, length = 5),
  validation = "Mfold",
  folds = 10,
  dist = "max.dist",
  measure = ifelse(method == "spls", "cor", "BER"),
  auc = FALSE,
  progressBar = FALSE,
  near.zero.var = FALSE,
  logratio = c("none", "CLR"),
  center = TRUE,
  scale = TRUE,
  max.iter = 100,
  tol = 1e-09,
  light.output = TRUE,
  BPPARAM = SerialParam()
)
}
\arguments{
\item{method}{This parameter is used to pass all other argument to the
suitable function. \code{method} has to be one of the following: "spls",
"splsda", "mint.splsda", "rcc", "pca", "spca" or "pls".}

\item{X}{numeric matrix of predictors. \code{NA}s are allowed.}

\item{Y}{Either a factor or a class vector for the discrete outcome, or a
numeric vector or matrix of continuous responses (for multi-response
models).}

\item{multilevel}{Design matrix for multilevel analysis (for repeated
measurements) that indicates the repeated measures on each individual, i.e.
the individuals ID. See Details.}

\item{ncomp}{the number of components to include in the model.}

\item{study}{grouping factor indicating which samples are from the same
study}

\item{test.keepX}{numeric vector for the different number of variables to
test from the \eqn{X} data set}

\item{test.keepY}{If \code{method = 'spls'}, numeric vector for the
different number of variables to test from the \eqn{Y} data set}

\item{already.tested.X}{Optional, if \code{ncomp > 1} A numeric vector
indicating the number of variables to select from the \eqn{X} data set on
the firsts components.}

\item{already.tested.Y}{if \code{method = 'spls'} and \code{if(ncomp > 1)}
numeric vector indicating the number of variables to select from the \eqn{Y}
data set on the first components}

\item{mode}{character string. What type of algorithm to use, (partially)
matching one of \code{"regression"}, \code{"canonical"}, \code{"invariant"}
or \code{"classic"}. See Details.}

\item{nrepeat}{Number of times the Cross-Validation process is repeated.}

\item{grid1, grid2}{vector numeric defining the values of \code{lambda1} and
\code{lambda2} at which cross-validation score should be computed. Defaults
to \code{grid1=grid2=seq(0.001, 1, length=5)}.}

\item{validation}{character.  What kind of (internal) validation to use,
matching one of \code{"Mfold"} or \code{"loo"} (see below). Default is
\code{"Mfold"}.}

\item{folds}{the folds in the Mfold cross-validation. See Details.}

\item{dist}{distance metric to estimate the
classification error rate, should be a subset of \code{"centroids.dist"},
\code{"mahalanobis.dist"} or \code{"max.dist"} (see Details).}

\item{measure}{The tuning measure used for different methods. See details.}

\item{auc}{if \code{TRUE} calculate the Area Under the Curve (AUC)
performance of the model.}

\item{progressBar}{by default set to \code{TRUE} to output the progress bar
of the computation.}

\item{near.zero.var}{Logical, see the internal \code{\link{nearZeroVar}}
function (should be set to TRUE in particular for data with many zero
values). Default value is FALSE}

\item{logratio}{one of ('none','CLR'). Default to 'none'}

\item{center}{a logical value indicating whether the variables should be
shifted to be zero centered. Alternately, a vector of length equal the
number of columns of \code{X} can be supplied. The value is passed to
\code{\link{scale}}.}

\item{scale}{a logical value indicating whether the variables should be
scaled to have unit variance before the analysis takes place. The default is
\code{FALSE} for consistency with \code{prcomp} function, but in general
scaling is advisable. Alternatively, a vector of length equal the number of
columns of \code{X} can be supplied. The value is passed to
\code{\link{scale}}.}

\item{max.iter}{Integer, the maximum number of iterations.}

\item{tol}{Numeric, convergence tolerance criteria.}

\item{light.output}{if set to FALSE, the prediction/classification of each
sample for each of \code{test.keepX} and each comp is returned.}

\item{BPPARAM}{A \linkS4class{BiocParallelParam} object indicating the type
of parallelisation. See examples.}
}
\value{
Depending on the type of analysis performed and the input arguments,
a list that may contain:

\item{error.rate}{returns the prediction error for each \code{test.keepX} on
each component, averaged across all repeats and subsampling folds. Standard
deviation is also output. All error rates are also available as a list.}
\item{choice.keepX}{returns the number of variables selected (optimal keepX)
on each component.} \item{choice.ncomp}{For supervised models; returns the
optimal number of components for the model for each prediction distance
using one-sided t-tests that test for a significant difference in the mean
error rate (gain in prediction) when components are added to the model. See
more details in Rohart et al 2017 Suppl. For more than one block, an optimal
ncomp is returned for each prediction framework.}
\item{error.rate.class}{returns the error rate for each level of \code{Y}
and for each component computed with the optimal keepX}

\item{predict}{Prediction values for each sample, each \code{test.keepX},
each comp and each repeat. Only if light.output=FALSE}
\item{class}{Predicted class for each sample, each \code{test.keepX}, each
comp and each repeat. Only if light.output=FALSE}

\item{auc}{AUC mean and standard deviation if the number of categories in
\code{Y} is greater than 2, see details above. Only if auc = TRUE}

\item{cor.value}{only if multilevel analysis with 2 factors: correlation
between latent variables.}
}
\description{
This function uses repeated cross-validation to tune hyperparameters such as
the number of features to select and possibly the number of components to
extract.
}
\details{
See the help file corresponding to the corresponding \code{method}, e.g.
\code{tune.splsda} for further details. Note that only the arguments used in
the tune function corresponding to \code{method} are passed on.

More details about the prediction distances in \code{?predict} and the
supplemental material of the mixOmics article (Rohart et al. 2017). More
details about the PLS modes are in \code{?pls}.
}
\examples{
## sPLS-DA
data(breast.tumors)
X <- breast.tumors$gene.exp
Y <- as.factor(breast.tumors$sample$treatment)
tune= tune(method = "splsda", X, Y, ncomp=1, nrepeat=10, logratio="none",
test.keepX = c(5, 10, 15), folds=10, dist="max.dist", progressBar = TRUE)

plot(tune)

\dontrun{
## mint.splsda

data(stemcells)
data = stemcells$gene
type.id = stemcells$celltype
exp = stemcells$study

out = tune(method="mint.splsda", X=data,Y=type.id, ncomp=2, study=exp, test.keepX=seq(1,10,1))
out$choice.keepX

plot(out)
}
}
\references{
Singh A., Shannon C., Gautier B., Rohart F., Vacher M., Tebbutt S.
and Lê Cao K.A. (2019), DIABLO: an integrative approach for identifying key 
molecular drivers from multi-omics assays, Bioinformatics, 
Volume 35, Issue 17, 1 September 2019, Pages 3055–3062.	

mixOmics article:

Rohart F, Gautier B, Singh A, Lê Cao K-A. mixOmics: an R package for 'omics
feature selection and multiple data integration. PLoS Comput Biol 13(11):
e1005752

MINT:

Rohart F, Eslami A, Matigian, N, Bougeard S, Lê Cao K-A (2017). MINT: A
multivariate integrative approach to identify a reproducible biomarker
signature across multiple experiments and platforms. BMC Bioinformatics
18:128.

PLS and PLS citeria for PLS regression: Tenenhaus, M. (1998). \emph{La
regression PLS: theorie et pratique}. Paris: Editions Technic.

Chavent, Marie and Patouille, Brigitte (2003). Calcul des coefficients de
regression et du PRESS en regression PLS1. \emph{Modulad n}, \bold{30} 1-11.
(this is the formula we use to calculate the Q2 in perf.pls and perf.spls)

Mevik, B.-H., Cederkvist, H. R. (2004). Mean Squared Error of Prediction
(MSEP) Estimates for Principal Component Regression (PCR) and Partial Least
Squares Regression (PLSR). \emph{Journal of Chemometrics} \bold{18}(9),
422-429.

sparse PLS regression mode:

Lê Cao, K. A., Rossouw D., Robert-Granie, C. and Besse, P. (2008). A sparse
PLS for variable selection when integrating Omics data. \emph{Statistical
Applications in Genetics and Molecular Biology} \bold{7}, article 35.

One-sided t-tests (suppl material):

Rohart F, Mason EA, Matigian N, Mosbergen R, Korn O, Chen T, Butcher S,
Patel J, Atkinson K, Khosrotehrani K, Fisk NM, Lê Cao K-A&, Wells CA&
(2016). A Molecular Classification of Human Mesenchymal Stromal Cells. PeerJ
4:e1845.
}
\seealso{
\code{\link{tune.rcc}}, \code{\link{tune.mint.splsda}},
\code{\link{tune.pca}}, \code{\link{tune.splsda}},
\code{\link{tune.splslevel}} and http://www.mixOmics.org for more details.
}
\author{
Florian Rohart, Francois Bartolo, Kim-Anh Lê Cao, Al J Abadi
}
\keyword{multivariate}
\keyword{regression}
