% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal_mint.block_helpers.R
\name{study_split}
\alias{study_split}
\title{divides a data matrix in a list of matrices defined by a factor}
\usage{
study_split(data, study)
}
\arguments{
\item{data}{numeric matrix of predictors}

\item{study}{grouping factor indicating which samples are from the same
study}
}
\value{
\code{study_split} simply returns a list of the same length as the
number of levels of \code{study} that contains sub-matrices of \code{data}.
}
\description{
\code{study_split} divides a data matrix in a list of matrices defined by a
\code{study} input.
}
\examples{
data(stemcells)
data = stemcells$gene
exp = stemcells$study

data.list = study_split(data, exp)

names(data.list)
lapply(data.list, dim)
table(exp)
}
\seealso{
\code{\link{mint.pls}}, \code{\link{mint.spls}},
\code{\link{mint.plsda}}, \code{\link{mint.splsda}}.
}
\author{
Florian Rohart, Al J Abadi
}
\keyword{multivariate}
\keyword{regression}
