% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image.tune.rcc.R
\name{image.tune.rcc}
\alias{image.tune.rcc}
\alias{plot.tune.rcc}
\title{Plot the cross-validation score.}
\usage{
\method{image}{tune.rcc}(x, col = heat.colors, ...)

\method{plot}{tune.rcc}(x, col = heat.colors, ...)
}
\arguments{
\item{x}{object returned by \code{tune.rcc}.}

\item{col}{a character string specifying the colors function to use:
\code{\link{terrain.colors}}, \code{\link{topo.colors}},
\code{\link{rainbow}} or similar functions. Defaults to
\code{\link{heat.colors}}.}

\item{...}{not used currently.}
}
\value{
none
}
\description{
This function provide a image map (checkerboard plot) of the
cross-validation score obtained by the \code{tune.rcc} function.
}
\details{
\code{plot.tune.rcc} creates an image map of the matrix \code{object$mat}
containing the cross-validation score obtained by the \code{tune.rcc}
function. Also a color scales strip is plotted.
}
\examples{

data(nutrimouse)
X <- nutrimouse$lipid
Y <- nutrimouse$gene

## this can take some seconds
cv.score <- tune.rcc(X, Y, validation = "Mfold", plot = FALSE)
plot(cv.score)

# image(cv.score) # same result as plot()
}
\seealso{
\code{\link{tune.rcc}}, \code{\link{image}}.
}
\author{
Sébastien Déjean, Ignacio González, Kim-Anh Le Cao, Al J Abadi
}
\keyword{dplot}
\keyword{hplot}
