% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{QQplotgg}
\alias{QQplotgg}
\alias{QQplotgg.default}
\alias{QQplotgg.dist}
\alias{QQnormgg}
\title{Implementation of Quantile-Quantile Plot with ggplot2}
\usage{
QQplotgg(
  d1,
  d2,
  line = TRUE,
  col = "#F9D607",
  line_col = "#f28df9",
  xlab = deparse(substitute(d1)),
  ylab,
  main = "Q-Q plot",
  alpha,
  lwd = 1,
  ...
)

\method{QQplotgg}{default}(
  d1,
  d2,
  line = TRUE,
  col = "#F9D607",
  line_col = "#f28df9",
  xlab = deparse(substitute(d1)),
  ylab = deparse(substitute(d2)),
  main = "Q-Q plot",
  alpha = 0.5,
  lwd = 1,
  ...
)

\method{QQplotgg}{dist}(
  d1,
  d2,
  line = TRUE,
  col = "#F9D607",
  line_col = "#f28df9",
  xlab = deparse(substitute(d1)),
  ylab = ylabe,
  main = "Q-Q plot",
  alpha = 0.7,
  lwd = 1,
  CI = re,
  CI_alpha = 0.4,
  CI_col = line_col,
  conf = 0.95,
  n = 100,
  ...
)

QQnormgg(d2, xlab = "Standard Normal", ylab = deparse(substitute(d2)), ...)
}
\arguments{
\item{d1}{distribution object or dataset.}

\item{d2}{distribution object or dataset.}

\item{line}{if qqline should be included, default: TRUE.}

\item{col}{color of points, default: '#F9D607'.}

\item{line_col}{color of qqline, default: '#f28df9'.}

\item{xlab}{xlab, default: deparse(substitute(d1)).}

\item{ylab}{ylab. default: deparse(substitute(d2)).}

\item{main}{title, default: 'Q-Q plot'.}

\item{alpha}{alpha of points, default: 0.7.}

\item{lwd}{lwd of qqline, default: 1.}

\item{...}{further arguments to be passed.}

\item{CI}{if confidence bound should be included.}

\item{CI_alpha}{alpha of confidence bound, default: 0.4.}

\item{CI_col}{color of confidence bound , default: line_col.}

\item{conf}{confidence level for confidence bound, default: 0.95.}

\item{n}{number of points at which quantile functions are evaluated if two distributions are compared, default: 100.}
}
\value{
ggplot object.
}
\description{
QQplotgg is a generic function that produces QQ plot of two datasets, distribution and dataset or two distributions.
}
\details{
\code{QQplotgg} is able to compare any combination of dataset and distributions.

         \code{QQnormgg} is a wrapper around \code{QQplotgg}, where d1 is set to \code{normdist()}.

         If quantiles of a continuous distribution are compared with a sample, a confidence bound
         for data is offered. This confidence "envelope" is based on the asymptotic results
         of the order statistics. For more details see \url{https://en.wikipedia.org/wiki/Order_statistic}.
}
\examples{
# sample vs sample
QQplotgg(r(normdist(), 10000), r(tdist(df = 4), 10000))

# distribution vs sample
QQplotgg(normdist(), r(tdist(df = 4), 10000))

# distribution vs distribution
QQplotgg(normdist(), tdist(df = 4))
}
