% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mc_cat.R
\name{mc_cat}
\alias{mc_cat}
\title{Display object contents}
\usage{
mc_cat(target, offset = 0, tail = 0, flags = "")
}
\arguments{
\item{target}{character string specifying the target directory path.}

\item{offset}{start offset, default 0 if not specified}

\item{tail}{tail number of bytes at ending of file, default 0 if not specified}

\item{flags}{additional flags to be passed to the \code{cat} command.
Default is an empty string.}
}
\value{
a character string with the contents of the file
}
\description{
The cat command returns the contents of the object as a string. This can
be useful when reading smaller files (without first downloading to disk).
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# upload a file to a bucket and read it back
install_mc()
mc_mb("play/mcr")
mc_cp(system.file(package = "minioclient", "DESCRIPTION"), "play/mcr/DESCRIPTION")
mc_cat("play/mcr/DESCRIPTION")
\dontshow{\}) # examplesIf}
}
