% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg_PPB.R
\name{PPB}
\alias{PPB}
\title{Percentage Proportional Bias (PPB)}
\usage{
PPB(data = NULL, obs, pred, tidy = FALSE, na.rm = TRUE)
}
\arguments{
\item{data}{(Optional) argument to call an existing data frame containing the data.}

\item{obs}{Vector with observed values (numeric).}

\item{pred}{Vector with predicted values (numeric).}

\item{tidy}{Logical operator (TRUE/FALSE) to decide the type of return. TRUE
returns a data.frame, FALSE returns a list; Default : FALSE.}

\item{na.rm}{Logic argument to remove rows with missing values
(NA). Default is na.rm = TRUE.}
}
\value{
an object of class \code{numeric} within a \code{list} (if tidy = FALSE) or within a
\verb{data frame} (if tidy = TRUE).
}
\description{
It estimates the contribution of the proportional bias to the Mean Squared Error (MSE)
following Correndo et al. (2021).
}
\details{
The PPB (\%) measures the contribution of proportional bias to the MSE.
The PPB = 100*(((sO - sP)^2)/MSE), where sO, and sP are the sample variances
of observations and predictions, respectively.
The greater the value the greater the contribution of proportional bias to the prediction error.
For the formula and more details, see \href{https://adriancorrendo.github.io/metrica/articles/available_metrics_regression.html}{online-documentation}
}
\examples{
\donttest{
set.seed(1)
X <- rnorm(n = 100, mean = 0, sd = 10)
Y <- X + rnorm(n=100, mean = 0, sd = 3)
PPB(obs = X, pred = Y)
}
}
\references{
Correndo et al. (2021).
Revisiting linear regression to test agreement in continuous predicted-observed datasets.
\emph{Agric. Syst. 192, 103194.} \doi{10.1016/j.agsy.2021.103194}
}
