% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TMVN_methods.R
\name{mcmcsae-TMVN-method}
\alias{mcmcsae-TMVN-method}
\alias{m_direct}
\alias{m_Gibbs}
\alias{m_HMC}
\alias{m_HMCZigZag}
\alias{m_softTMVN}
\title{Functions for specifying the method and corresponding options for sampling
from a possibly truncated and degenerate multivariate normal distribution}
\usage{
m_direct()

m_Gibbs(slice = FALSE, diagnostic = FALSE, debug = FALSE)

m_HMC(
  Tsim = pi/2,
  max.events = .Machine$integer.max,
  diagnostic = FALSE,
  debug = FALSE
)

m_HMCZigZag(
  Tsim = 1,
  rate = 1,
  prec.eq = NULL,
  diagnostic = FALSE,
  max.events = .Machine$integer.max,
  adapt = FALSE,
  debug = FALSE
)

m_softTMVN(sharpness = 100, useV = FALSE, debug = FALSE)
}
\arguments{
\item{slice}{if \code{TRUE}, a Gibbs within slice sampler is used.}

\item{diagnostic}{whether information about violations of inequalities is printed to the screen}

\item{debug}{if \code{TRUE} a breakpoint is set at the beginning of the TMVN sampling
function. Mainly intended for developers.}

\item{Tsim}{the duration of a Hamiltonian Monte Carlo simulated particle trajectory.
This can be specified as either a single positive numeric value for a fixed
simulation time, or as a function that is applied in each MCMC iteration to
generates a simulation time.}

\item{max.events}{maximum number of events (reflections off inequality walls
and for method 'HMCZigZag' also gradient events). Default is unlimited.
Specifying a finite number may speed up the sampling but may also result
in a biased sampling algorithm.}

\item{rate}{vector of Laplace rate parameters for method 'HMCZigZag'. It must be
a positive numeric vector of length one or the number of variables.}

\item{prec.eq}{positive numeric vector of length 1 or the number of equality restrictions,
to control the precision with which the equality restrictions are imposed; the larger
\code{prec.eq} the more precisely they will be imposed.}

\item{adapt}{experimental feature: if \code{TRUE} the rate parameter will be adapted
in an attempt to make the sampling algorithm more efficient.}

\item{sharpness}{for method 'softTMVN', the sharpness of the soft inequalities; the larger the better
the approximation of exact inequalities. It must a positive numeric vector of length
one or the number of inequality restrictions.}

\item{useV}{for method 'softTMVN' whether to base computations on variance instead of precision
matrices.}
}
\value{
A method object, for internal use only.
}
\description{
These functions are intended for use in the \code{method} argument of \code{\link{create_TMVN_sampler}}.
In future versions these functions may gain additional arguments.
}
