% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LU.R
\name{LU}
\alias{LU}
\title{LU Decomposition}
\usage{
LU(A, b, tol = sqrt(.Machine$double.eps), verbose = FALSE, ...)
}
\arguments{
\item{A}{coefficient matrix}

\item{b}{right-hand side vector. When supplied the returned object will also contain the solved
\eqn{d} and \code{x} elements}

\item{tol}{tolerance for checking for 0 pivot}

\item{verbose}{logical; if \code{TRUE}, print intermediate steps}

\item{...}{additional arguments passed to \code{\link{showEqn}}}
}
\value{
A list of matrix components of the solution, \code{P}, \code{L} and \code{U}. If \code{b}
       is supplied, the vectors \eqn{d} and \code{x} are also returned.
}
\description{
\code{LU} computes the LU decomposition of a matrix, \eqn{A}, such that \eqn{P A = L U},
where \eqn{L} is a lower triangle matrix, \eqn{U} is an upper triangle, and \eqn{P} is a
permutation matrix.
}
\details{
The LU decomposition is used to solve the equation \eqn{A x = b} by calculating
\eqn{L(Ux - d) = 0}, where \eqn{Ld = b}. If row exchanges are necessary for
\eqn{A} then the permutation matrix \eqn{P} will be required to exchange the rows in \eqn{A};
otherwise, \eqn{P} will be an identity matrix and the LU equation will be simplified to
\eqn{A = L U}.
}
\examples{

  A <- matrix(c(2, 1, -1,
               -3, -1, 2,
               -2,  1, 2), 3, 3, byrow=TRUE)
  b <- c(8, -11, -3)
  (ret <- LU(A)) # P is an identity; no row swapping
  with(ret, L \%*\% U) # check that A = L * U
  LU(A, b)
  
  LU(A, b, verbose=TRUE)
  LU(A, b, verbose=TRUE, fractions=TRUE)

  # permutations required in this example
  A <- matrix(c(1,  1, -1,
                2,  2,  4,
                1, -1,  1), 3, 3, byrow=TRUE)
  b <- c(1, 2, 9)
  (ret <- LU(A, b))
  with(ret, P \%*\% A)
  with(ret, L \%*\% U)

}
\author{
Phil Chalmers
}
