% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markov_mix.R
\name{fit_markov_mix}
\alias{fit_markov_mix}
\title{Fit mixture of Markov chains}
\usage{
fit_markov_mix(
  seq_list,
  order. = 1L,
  states = NULL,
  clusters = NULL,
  verbose = TRUE
)
}
\arguments{
\item{seq_list}{Sequence list containing vectors of the same class.}

\item{order.}{Integer (1L) indicating the order of the Markov chain.}

\item{states}{\code{NULL} or vector indicating the states in the Markov chain.
If \code{NULL}, states are inferred from unique non-NA elements in all the sequences.
If vector, it should match the class of the sequences. NA elements in the vector are removed.}

\item{clusters}{\code{NULL} or matrix containing clustering probabilities.
If \code{NULL}, Markov chain is fit without mixture components.
If matrix, rows are probabilities of sequences and columns are components.
As probabilities of sequences, rows are normalized to sum up to 1.}

\item{verbose}{Logical (1L) indicating whether additional messages should be printed.}
}
\value{
An object of class \code{\link{MarkovMix}}.
}
\description{
\code{fit_markov_mix} fits mixture of Markov chains. It supports high-order Markov chains,
multiple sequences and mixture components with cluster probabilities.
}
\note{
Change log:
\itemize{
\item{0.1.0 Xiurui Zhu - Initiate the function.}
}
}
\examples{
# Generate a list of integer sequences of different lengths with 4 states
test_states <- seq_len(4L)
test_maxlen <- 10L
set.seed(1111L)
test_seq <- purrr::map(
  seq_len(100L),
  ~ sample(test_states, sample.int(test_maxlen, 1L), replace = TRUE)
)

# Fit a 1-order Markov chain
markov_fit <- fit_markov_mix(
  seq_list = test_seq,
  order. = 1L,
  states = test_states
)
print(markov_fit)

# Fit a mixture of 2-order Markov chain with 3 components
test_n_comp <- 3L
test_clusters <- matrix(
  runif(length(test_seq) * test_n_comp),
  nrow = length(test_seq),
  ncol = test_n_comp
)
markov_mix_fit <- fit_markov_mix(
  seq_list = test_seq,
  order. = 2L,
  states = test_states,
  clusters = test_clusters
)
print(markov_mix_fit)
}
\author{
Xiurui Zhu
}
