% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{riskRatioExactCI}
\alias{riskRatioExactCI}
\title{Exact unconditional confidence interval for risk ratio}
\usage{
riskRatioExactCI(
  n1 = NA_integer_,
  y1 = NA_integer_,
  n2 = NA_integer_,
  y2 = NA_integer_,
  cilevel = 0.95
)
}
\arguments{
\item{n1}{The sample size for the active treatment group.}

\item{y1}{The number of responses for the active treatment group.}

\item{n2}{The sample size for the control group.}

\item{y2}{The number of responses for the control group.}

\item{cilevel}{The confidence interval level.}
}
\value{
A data frame containing the following variables:
\itemize{
\item \code{scale}: The scale of treatment effect.
\item \code{estimate}: The point estimate.
\item \code{lower}: The lower limit of the confidence interval.
\item \code{upper}: The upper limit of the confidence interval.
\item \code{cilevel}: The confidence interval level.
}
}
\description{
Obtains the exact unconditional confidence interval for
risk ratio based on the standardized score statistic.
}
\examples{

riskRatioExactCI(n1 = 68, y1 = 2, n2 = 65, y2 = 1, cilevel = 0.95)

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
