% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{simonBayesSim}
\alias{simonBayesSim}
\title{Simulation of Simon's Bayesian basket trials}
\usage{
simonBayesSim(
  p = NA_real_,
  accrualTime = 0L,
  accrualIntensity = NA_real_,
  stratumFraction = 1L,
  lambda = NA_real_,
  gamma = NA_real_,
  phi = NA_real_,
  plo = NA_real_,
  T = NA_real_,
  maxSubjects = NA_integer_,
  plannedSubjects = NA_integer_,
  maxNumberOfIterations = 1000L,
  maxNumberOfRawDatasets = 1L,
  seed = NA_integer_
)
}
\arguments{
\item{p}{The vector of true response probabilities across strata.}

\item{accrualTime}{A vector that specifies the starting time of
piecewise Poisson enrollment time intervals. Must start with 0, e.g.,
\code{c(0, 3)} breaks the time axis into 2 accrual intervals:
[0, 3) and [3, Inf).}

\item{accrualIntensity}{A vector of accrual intensities. One for
each accrual time interval.}

\item{stratumFraction}{A vector of stratum fractions that sum to 1.
Defaults to 1 for no stratification.}

\item{lambda}{The prior probability that the drug activity is
homogeneous across strata.}

\item{gamma}{The prior probability that the drug is active in a
stratum.}

\item{phi}{The response probability for an active drug.}

\item{plo}{The response probability for an inactive drug.}

\item{T}{The threshold for a conclusive posterior probability to
stop enrollment.}

\item{maxSubjects}{The maximum total sample size.}

\item{plannedSubjects}{The planned cumulative number of subjects
at each stage.}

\item{maxNumberOfIterations}{The number of simulation iterations.
Defaults to 1000.}

\item{maxNumberOfRawDatasets}{The number of raw datasets to extract.}

\item{seed}{The seed to reproduce the simulation results.
The seed from the environment will be used if left unspecified,}
}
\value{
A list containing the following four components:
\itemize{
\item \code{rawdata}: A data frame for subject-level data, containing
the following variables:
\itemize{
\item \code{iterationNumber}: The iteration number.
\item \code{stageNumber}: The stage number.
\item \code{subjectId}: The subject ID.
\item \code{arrivalTime}: The enrollment time for the subject.
\item \code{stratum}: The stratum for the subject.
\item \code{y}: Whether the subject was a responder (1) or
nonresponder (0).
}
\item \code{sumdata1}: A data frame for simulation and stratum-level
summary data, containing the following variables:
\itemize{
\item \code{iterationNumber}: The iteration number.
\item \code{stageNumber}: The stage number.
\item \code{stratum}: The stratum number.
\item \code{active}: Whether the drug is active in the stratum.
\item \code{n}: The number of subjects in the stratum.
\item \code{r}: The number of responders in the stratum.
\item \code{posterior}: The posterior probability that the drug is
active in the stratum.
\item \code{open}: Whether the stratum is still open for enrollment.
\item \code{positive}: Whether the stratum has been determined to be
a positive stratum.
\item \code{negative}: Whether the stratum has been determined to be
a negative stratum.
}
\item \code{sumdata2}: A data frame for the simulation level summary data,
containing the following variables:
\itemize{
\item \code{iterationNumber}: The iteration number.
\item \code{numberOfStrata}: The total number of strata.
\item \code{n_active_strata}: The number of active strata.
\item \code{true_positive}: The number of true positive strata.
\item \code{false_negative}: The number of false negative strata.
\item \code{false_positive}: The number of false positive strata.
\item \code{true_negative}: The number of true negative strata.
\item \code{n_indet_strata}: The number of indeterminate strata.
\item \code{numberOfSubjects}: The number of subjects.
}
\item \code{overview}: A data frame for the summary across simulations,
containing the following variables:
\itemize{
\item \code{numberOfStrata}: The total number of strata.
\item \code{n_active_strata}: The average number of active strata.
\item \code{true_positive}: The average number of true positive strata.
\item \code{false_negative}: The average number of false negative strata.
\item \code{false_positive}: The average number of false positive strata.
\item \code{true_negative}: The average number of true negative strata.
\item \code{n_indet_strata}: The average number of indeterminate strata.
\item \code{numberOfSubjects}: The average number of subjects.
}
}
}
\description{
Obtains the simulated raw and summary data for Simon's
Bayesian basket discovery trials.
}
\examples{

sim1 = simonBayesSim(
  p = c(0.25, 0.25, 0.05),
  accrualIntensity = 5,
  stratumFraction = c(1/3, 1/3, 1/3),
  lambda = 0.33, gamma = 0.5,
  phi = 0.25, plo = 0.05,
  T = 0.8, maxSubjects = 50,
  plannedSubjects = seq(5, 50, 5),
  maxNumberOfIterations = 1000,
  maxNumberOfRawDatasets = 1,
  seed = 314159)

sim1$overview

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
