% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{fwgtmat}
\alias{fwgtmat}
\title{Weight matrix for all intersection hypotheses}
\usage{
fwgtmat(w, G)
}
\arguments{
\item{w}{The vector of weights for elementary hypotheses.}

\item{G}{The transition matrix.}
}
\value{
The weight matrix starting with the global null hypothesis.
}
\description{
Obtains the weight matrix for all intersection hypotheses.
}
\examples{

w = c(0.5,0.5,0,0)
g = matrix(c(0,0,1,0, 0,0,0,1, 0,1,0,0, 1,0,0,0),
           nrow=4, ncol=4, byrow=TRUE)
(wgtmat = fwgtmat(w,g))

}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
