% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_config.R
\name{check_config}
\alias{check_config}
\title{Check the validity of LPJmL config JSON files}
\usage{
check_config(
  x,
  model_path = ".",
  sim_path = NULL,
  return_output = FALSE,
  raise_error = FALSE,
  output_path = NULL
)
}
\arguments{
\item{x}{\code{job_details} object returned by \code{\link[=write_config]{write_config()}} or
character vector providing the config file names
(hint: returns \code{x} as a list entry).}

\item{model_path}{Character string providing the path to LPJmL
(equal to \code{LPJROOT} environment variable). Defaults to ".".}

\item{sim_path}{Character string defining path where all simulation data are
written, including output, restart and configuration files. If \code{NULL},
\code{model_path} is used. See also \link{write_config}}

\item{return_output}{Parameter affecting the output. If \code{FALSE} print
stdout/stderr message. If \code{TRUE}, return the result of the check.
Defaults to \code{FALSE}.}

\item{raise_error}{Logical. Whether to raise an error if sub-process has
non-zero exit status. Defaults to \code{FALSE}.}

\item{output_path}{Argument is deprecated as of version 1.0; use sim_path
instead.}
}
\value{
NULL.
}
\description{
Check if created LPJmL config JSON files (\code{\link[=write_config]{write_config()}}) are
valid and are ready to be used for simulations using lpjcheck for multiple
files.
}
\examples{
\dontrun{
library(tibble)
library(lpjmlkit)

model_path <- "./LPJmL_internal"
sim_path <-"./my_runs"


# Basic usage
my_params <- tibble(
  sim_name = c("scen1", "scen2"),
  random_seed = c(12, 404),
  `pftpar[[1]]$name` = c("first_tree", NA),
  `param$k_temp` = c(NA, 0.03),
  new_phenology = c(TRUE, FALSE)
)

config_details <- write_config(
  x = my_params,
  model_path = model_path,
  sim_path = sim_path
)

check_config(x = config_details,
  model_path = model_path,
  sim_path = sim_path,
  return_output = FALSE
)
}
}
