% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LPJmLData_as.R
\name{as_raster}
\alias{as_raster}
\title{Coerce an LPJmLData object to a raster object}
\usage{
as_raster(x, subset = NULL, aggregate = NULL, ...)
}
\arguments{
\item{x}{\link{LPJmLData} object}

\item{subset}{List of array dimension(s) as name/key and
corresponding subset vector as value, e.g.\code{list(cell = c(27411:27415))}.
More information at \code{\link[=subset.LPJmLData]{subset.LPJmLData()}}.}

\item{aggregate}{List of array dimension(s) as name/key and
corresponding aggregation function as value, e.g. \code{list(band = sum)}.}

\item{...}{Arguments passed to the aggregate function(s), e.g.
\code{na.rm = TRUE}.}
}
\value{
A \link[raster]{raster} or \link[raster]{brick} object with spatial extent
and coordinates based on internal \verb{$grid} attribute and containing a lon/lat
representation of \code{x$data}. If multiple bands or time steps exist, a
\link[raster]{brick} is created. Further meta information such as the
lon/lat resolution are extracted from \verb{$meta}.
}
\description{
Function to coerce (convert) an \code{\link{LPJmLData}} object into a
\link[raster]{raster} or \link[raster]{brick} object that allows for any
GIS-based raster operations.
Read more about the raster package at
\url{https://rspatial.github.io/raster/reference/raster-package.html}.
The successor package of raster is called terra: \url{https://rspatial.org/}.
}
\details{
The \verb{$grid} attribute is required for spatial transformation. When
using \code{file_type = "meta"}, grid data are usually read automatically via
\code{\link[=add_grid]{add_grid()}} if the grid file is present in the same directory. Otherwise,
\code{add_grid()} has to be called explicitly with the path to a matching grid
file. Supports either multiple bands or multiple time steps. Use \code{subset} or
\code{aggregate} to reduce data with multiple bands and time steps.
}
\examples{
\dontrun{

vegc <- read_io(filename = "./vegc.bin.json")

# Returns a RasterBrick for all data
as_raster(vegc)
# class      : RasterBrick
# dimensions : 280, 720, 201600, 200  (nrow, ncol, ncell, nlayers)
# resolution : 0.5, 0.5  (x, y)
# extent     : -180, 180, -56, 84  (xmin, xmax, ymin, ymax)
# crs        : +proj=longlat +datum=WGS84 +no_defs
# source     : memory
# names      : X1901.12.31, X1902.12.31, X1903.12.31, X1904.12.31, ...
# min values :           0,           0,           0,           0, ...
# max values :    28680.72,    28662.49,    28640.29,    28634.03, ...

}

}
