% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_varfile.R
\name{find_varfile}
\alias{find_varfile}
\title{Search for a variable file in a directory}
\usage{
find_varfile(searchdir, variable = "grid", strict = FALSE)
}
\arguments{
\item{searchdir}{Directory where to look for the variable file.}

\item{variable}{Single character string containing the variable to search for}

\item{strict}{Boolean. If set to \code{TRUE}, file must be named "variable.\strong{",
where "}" is one or two file extensions with 3 or 4 characters, e.g.
"grid.bin.json" if \code{variable = "grid"}. If set to \code{FALSE}, the function
will first try to match the strict pattern. If unsuccessful, any filename
that starts with "variable" will be matched.}
}
\value{
Character string with the file name of a matched file, including the
full path.
}
\description{
Function to search for a file containing a specific variable in a specific
directory.
}
\details{
This function looks for file names in \code{searchdir} that match the
\code{pattern} parameter in its \code{\link[=list.files]{list.files()}} call. Files of type "meta" are
preferred. Files of type "clm" are also accepted. The function returns an
error if no suitable file or multiple files are found.
}
