% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_array.R
\name{asub}
\alias{asub}
\title{Subset a named array}
\usage{
asub(x, ..., drop = TRUE)
}
\arguments{
\item{x}{An array with named dimensions.}

\item{...}{One or several vectors of indices or character strings to be used
to subset \code{x}. Argument names refer to the dimension name to be subset,
while argument values specify the selected elements along the respective
dimension. Examples: \code{cell = c(27411:27416)}, \code{band = -c(14:16, 19:32)},
\code{band = c("rainfed rice","rainfed maize")}.}

\item{drop}{Logical. If \code{TRUE} (default), dimensions with a length of 1 are
dropped from the result. Otherwise, they are kept.}
}
\value{
array (or vector if \code{drop = TRUE} and only one dimension is left)
of the selected subset of \code{x}.
}
\description{
Subset an array with the supplied dimnames and - if defined - replace values.
}
\examples{
my_array <- array(1,
                  dim = c(cell = 67, month = 12, band = 3),
                  dimnames = list(cell = 0:66,
                                month = 1:12,
                                band = c("band1", "band2", "band3")))
my_subset <- asub(my_array,
                  band = c("band1", "band3"))
dimnames(my_subset)[3]
# $ band
#   [1] "band1"
#   [2] "band3"

}
