% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvncovar1.R
\name{mvncovar1}
\alias{mvncovar1}
\title{Bayesian multivariate regression with independent covariance  matrix for high dimensional longitudinal data.}
\usage{
mvncovar1(m, n, time, group, chains, iter, data)
}
\arguments{
\item{m}{Starting number of column from where repeated observations begin}

\item{n}{Ending number of columns till where the repeated observations ends}

\item{time}{Timepoint information on which repeadted observations were taken}

\item{group}{A categorical variable either 0 or 1. i.e. Gender - 1 male and 0 female}

\item{chains}{Number of MCMC chains to be performed}

\item{iter}{Number of iterations to be performed}

\item{data}{High dimensional longitudinal data}
}
\value{
mvncovarout lists posterior omega and sigma values.
}
\description{
Multivariate Regression with independent covariance  matrix in longitudinal datasetup with high dimensional.
}
\examples{
##
data(repdata)
mvncovar1(m=4,n=7,time="Age",group="Gender",chains=10,iter=100,repdata)
##
}
\references{
Bhattacharjee, A. (2020). Bayesian Approaches in Oncology Using R and OpenBUGS. CRC Press.

Gelman, A., Carlin, J. B., Stern, H. S., Dunson, D. B., Vehtari, A., & Rubin, D. B. (2013). Bayesian data analysis. CRC press.

Fitzmaurice, G. M., Laird, N. M., & Ware, J. H. (2012). Applied longitudinal analysis (Vol. 998). John Wiley & Sons.
}
\author{
Atanu Bhattacharjee, Akash Pawar and Bhrigu Kumar Rajbongshi
}
