% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expectreg_locpol.R
\name{expectreg_locpol}
\alias{expectreg_locpol}
\title{Local polynomial expectile regression (iterative procedure), univariate covariate}
\usage{
expectreg_locpol(
  X,
  Y,
  j = 0,
  p = 1,
  omega,
  h,
  kernel = gaussK,
  starting_value = c("mean", "median", "omega-quantile"),
  grid = seq(min(X), max(X), length.out = 100)
)
}
\arguments{
\item{X}{The covariate data values.}

\item{Y}{The response data values.}

\item{j}{The order of derivative of the expectile to be estimated. In default setting, \code{j=0}
(i.e. estimating the expectile regression function).}

\item{p}{The order of the local polynomial estimator. In default setting,
\code{p=1} (i.e. local linear estimator).}

\item{omega}{Numeric vector of level between 0 and 1 where 0.5 corresponds
to the mean.}

\item{h}{Smoothing parameter, bandwidth.}

\item{kernel}{The kernel used to perform the estimation. In default setting,
\code{kernel=gaussK}. See details in \code{\link[locpol]{Kernels}}.}

\item{starting_value}{Method for the starting point. Choice between the
estimated (unconditional) mean, median and omega-quantile.}

\item{grid}{Vector of evaluation points. In default setting, a grid of 100
equispaced grid-values on the domain of the variable \eqn{X}.}
}
\value{
\code{\link{expectreg_locpol}} local polynomial expectile estimator
proposed and studied by Adam and Gijbels (2021a).
}
\description{
Formula interface for the local polynomial expectile estimation.
}
\examples{
library(locpol)
data(mcycle)
y=mcycle$accel
x=mcycle$times

expectreg_locpol(X=x,Y=y,omega=0.3,h=0.4,kernel=gaussK,starting_value="mean"
,grid=seq(min(x),max(x),length.out=10))

}
\references{
{

Adam, C. and Gijbels, I. (2021a). Local polynomial expectile regression.
Annals of the Institute of Statistical Mathematics doi:10.1007/s10463-021-00799-y.

}
}
