% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{s.combine.stats4}
\alias{s.combine.stats4}
\title{Combine Mean, Variance, Skewness, and Kurtosis
This function combines two sets of mean, variance, skewness, and kurtosis and generates the combined statistics.}
\usage{
s.combine.stats4(list1, list2)
}
\arguments{
\item{list1}{A list representing the first \code{mean}, \code{variance}, \code{skewness}, \code{kurtosis}, \code{weight}, and \code{count}.}

\item{list2}{A list representing the second distribution (similar to \code{list1}).}
}
\value{
A list similar to \code{list1}.
}
\description{
Combine Mean, Variance, Skewness, and Kurtosis
This function combines two sets of mean, variance, skewness, and kurtosis and generates the combined statistics.
}
\details{
Assume there are two samples with \eqn{mean_i}, \eqn{variance_i}, \eqn{skewness_i}, and \eqn{kurtosis_i} for \eqn{i=1,2},
this function calculates the mean, variance, skewness, and kurtosis of the combined sample.
It does not need the data itself.
It is based on population variance, skewness, and kurtosis and calculates the population statistics.
Note that the kurtosis is not excess kurtosis.
}
\examples{
n <- 1000 # sample size (increase it for more accurate result)
sample1 <- rchisq(n,3)
sample2 <- rchisq(n,5)

d1 <- list(mean = mean(sample1),
           variance = var(sample1),
           skewness = moments::skewness(sample1),
           kurtosis = moments::kurtosis(sample1),
           count=length(sample1),
           weight = length(sample1))
d2 <- list(mean = mean(sample2),
           variance = var(sample2),
           skewness = moments::skewness(sample2),
           kurtosis = moments::kurtosis(sample2),
           count=length(sample2),
           weight = length(sample2))
c <- s.combine.stats4(d1,d2)

# we can compare the results:
combined <- c(sample1,sample2)
mean_c = mean(combined)
variance_c = var(combined)
skewness_c = moments::skewness(combined)
kurtosis_c = moments::kurtosis(combined)

}
