% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{rand.mnormal}
\alias{rand.mnormal}
\title{Generate Random Samples from a Multivariate Normal Distribution}
\usage{
rand.mnormal(n, mu = NULL, sigma = NULL, p = NULL, byRow = TRUE)
}
\arguments{
\item{n}{The number of samples to generate.}

\item{mu}{The mean vector of the distribution.
If \code{NULL}, it defaults to a zero vector of length \code{p}.
If \code{NA}, it is set to a random vector.}

\item{sigma}{The covariance matrix of the distribution.
If \code{NULL}, it defaults to an identity matrix of size \code{p x p}.
If \code{NA}, it is set to a random positive definite matrix.}

\item{p}{The dimension of the distribution, if both \code{mu} and \code{sigma} are \code{NA} or \code{NULL}.}

\item{byRow}{If \code{TRUE}, generated samples are stored in the rows. Otherwise, they are stored in the columns.}
}
\value{
A list containing the generated sample (\code{p x n}), \code{mu}, and \code{sigma}.
}
\description{
Use this function to get random samples from a multivariate normal distribution.
}
\examples{
s1 <- rand.mnormal(10, mu = c(0, 0), sigma = matrix(c(1, 0.5, 0.5, 1), ncol = 2))
s2 <- rand.mnormal(10, mu = c(1,1), sigma = NA, p = 2)
s3 <- rand.mnormal(10, p = 2, byRow = FALSE) #standard normal

}
