% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{s.gld.from.moments}
\alias{s.gld.from.moments}
\title{Get the GLD Parameters from the moments}
\usage{
s.gld.from.moments(
  mean = 0,
  variance = 1,
  skewness = 0,
  excessKurtosis = 0,
  type = 0,
  start = NULL,
  nelderMeadOptions = get.options.neldermead(),
  printMsg = FALSE
)
}
\arguments{
\item{mean}{A number for the mean of the distribution.}

\item{variance}{A number for the variance of the distribution.}

\item{skewness}{A number for the skewness of the distribution.}

\item{excessKurtosis}{A number for the excess kurtosis of the distribution.}

\item{type}{An integer to restrict the shape of the distribution. See details section.}

\item{start}{A numeric vector of size 2 for the starting value.}

\item{nelderMeadOptions}{A list of options for Nelder-Mead algorithm. Use \link{get.options.neldermead} for initialization.}

\item{printMsg}{Set to \code{TRUE} to enable printing some details.}
}
\value{
A vector of length 5. The first 4 elements are the parameters of the GLD distribution.
The last one is the number of iterations.
}
\description{
Calculates the parameters of the generalized lambda distribution (FKML), given the first four moments of the distribution.
}
\details{
The type of the distribution is determined by one or two restrictions:
\itemize{
\item \strong{type 0:} general, no restriction
\item \strong{type 1:} symmetric 'type 0', p3 == p4
\item \strong{type 2:} uni-modal continuous tail, p3 < 1 & p4 < 1
\item \strong{type 3:} symmetric 'type 2', p3 == p4
\item \strong{type 4:} uni-modal continuous tail finite slope, p3 <= 0.5 & p4 <= 0.5
\item \strong{type 5:} symmetric 'type 4', p3 == p4
\item \strong{type 6:} uni-modal truncated density curves, p3 >= 2 & p4 >= 2 (includes uniform distribution)
\item \strong{type 7:} symmetric 'type 6', p3 == p4
\item \strong{type 8:} S shaped, (p3 > 2 & 1 < p4 < 2) or (1 < p3 < 2 & p4 > 2)
\item \strong{type 9:} U shaped, (1 < p3 <= 2) and (1 < p4 <= 2)
\item \strong{type 10:} symmetric 'type 9', p3 == p4
\item \strong{type 11:} monotone, p3 > 1 & p4 <= 1
}
}
\examples{
res <- s.gld.from.moments(0,1,0,0, start = c(0,0), type = 4)
probs <- seq(0.1,0.9,0.1)
x <- s.gld.quantile(probs, res[1],res[2],res[3],res[4])
y <- s.gld.density.quantile(probs, res[1],res[2],res[3],res[4])
plot(x,y)
lines(x,y)


}
