
#' Simulated data set (continuous regression outcome)
#' 
#' Simulated data set with continuous regression outcome. The data set contains
#' 100 observations of 13 variables, which include 10 manifest variables,
#' and two regressors - one continuous and one dummy.
#' 
#' \describe{
#'   \item{Y }{Continuous regression outcome of interest}
#'   \item{Z1 }{Categorical manifest variable 1}
#'   \item{Z2 }{Categorical manifest variable 2}
#'   \item{Z3 }{Categorical manifest variable 3}
#'   \item{Z4 }{Categorical manifest variable 4}
#'   \item{Z5 }{Categorical manifest variable 5}
#'   \item{Z6 }{Categorical manifest variable 6}
#'   \item{Z7 }{Categorical manifest variable 7}
#'   \item{Z8 }{Categorical manifest variable 8}
#'   \item{Z9 }{Categorical manifest variable 9}
#'   \item{Z10 }{Categorical manifest variable 10}
#'   \item{X1 }{Continuous predictor variable}
#'   \item{X2 }{Categorical variable with values 1, 0}
#' }
#' 
#'
#' @export

"paper_sim"

#' Simulated data set (discrete regression outcome)
#' 
#' Simulated data set with discrete regression outcome. The data set contains
#' 100 observations of 13 variables, which include 10 manifest variables,
#' and two regressors - one continuous and one dummy.
#' 
#' \describe{
#'   \item{Y }{Discrete regression outcome of interest}
#'   \item{Z1 }{Categorical manifest variable 1}
#'   \item{Z2 }{Categorical manifest variable 2}
#'   \item{Z3 }{Categorical manifest variable 3}
#'   \item{Z4 }{Categorical manifest variable 4}
#'   \item{Z5 }{Categorical manifest variable 5}
#'   \item{Z6 }{Categorical manifest variable 6}
#'   \item{Z7 }{Categorical manifest variable 7}
#'   \item{Z8 }{Categorical manifest variable 8}
#'   \item{Z9 }{Categorical manifest variable 9}
#'   \item{Z10 }{Categorical manifest variable 10}
#'   \item{X1 }{Continuous predictor variable}
#'   \item{X2 }{Categorical variable with values 1, 0}
#' }
#'
#'
#' @export

"paper_sim_binary"

#' Simulated data set number 2 (continuous regression outcome)
#' 
#' Simulated data set with continuous regression outcome. The data set contains
#' 350 observations of 16 variables, which include 12 manifest variables,
#' and four regressors.
#' 
#' \describe{
#'   \item{y }{Discrete regression outcome of interest}
#'   \item{Z1 }{Categorical manifest variable 1}
#'   \item{Z2 }{Categorical manifest variable 2}
#'   \item{Z3 }{Categorical manifest variable 3}
#'   \item{Z4 }{Categorical manifest variable 4}
#'   \item{Z5 }{Categorical manifest variable 5}
#'   \item{Z6 }{Categorical manifest variable 6}
#'   \item{Z7 }{Categorical manifest variable 7}
#'   \item{Z8 }{Categorical manifest variable 8}
#'   \item{Z9 }{Categorical manifest variable 9}
#'   \item{Z10 }{Categorical manifest variable 10}
#'   \item{Z11 }{Categorical manifest variable 11}
#'   \item{Z12 }{Categorical manifest variable 12}
#'   \item{x1 }{Continuous predictor variable}
#'   \item{x2 }{Continuous predictor variable}
#'   \item{x3 }{Continuous predictor variable}
#'   \item{x4 }{Continuous predictor variable}
#' }
#'
#'
#' @export

"latent3"

#' Simulated data set number 2 (discrete regression outcome)
#' 
#' Simulated data set with discrete regression outcome. The data set contains
#' 350 observations of 16 variables, which include 12 manifest variables,
#' and four regressors.
#' 
#' \describe{
#'   \item{y }{Discrete regression outcome of interest}
#'   \item{Z1 }{Categorical manifest variable 1}
#'   \item{Z2 }{Categorical manifest variable 2}
#'   \item{Z3 }{Categorical manifest variable 3}
#'   \item{Z4 }{Categorical manifest variable 4}
#'   \item{Z5 }{Categorical manifest variable 5}
#'   \item{Z6 }{Categorical manifest variable 6}
#'   \item{Z7 }{Categorical manifest variable 7}
#'   \item{Z8 }{Categorical manifest variable 8}
#'   \item{Z9 }{Categorical manifest variable 9}
#'   \item{Z10 }{Categorical manifest variable 10}
#'   \item{Z11 }{Categorical manifest variable 11}
#'   \item{Z12 }{Categorical manifest variable 12}
#'   \item{x1 }{Continuous predictor variable}
#'   \item{x2 }{Continuous predictor variable}
#'   \item{x3 }{Continuous predictor variable}
#'   \item{x4 }{Continuous predictor variable}
#' }
#'
#'
#' @export

"latent3_binary"

#' Small simulated data set
#' 
#' Simulated data set with continuous regression outcome. The data set contains
#' 150 observations of 8 variables, which include 5 manifest variables,
#' and two regressors.
#' 
#' \describe{
#'   \item{y }{Discrete regression outcome of interest}
#'   \item{Z1 }{Categorical manifest variable 1}
#'   \item{Z2 }{Categorical manifest variable 2}
#'   \item{Z3 }{Categorical manifest variable 3}
#'   \item{Z4 }{Categorical manifest variable 4}
#'   \item{Z5 }{Categorical manifest variable 5}
#'   \item{x1 }{Continuous predictor variable}
#'   \item{x2 }{Continuous predictor variable}
#' }
#'
#'
#' @export

"express"
