% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liouville.R
\name{sliouv}
\alias{sliouv}
\title{Joint survival function of Liouville vectors}
\usage{
sliouv(theta, x, family, alphavec)
}
\arguments{
\item{theta}{parameter of the corresponding Archimedean copula}

\item{x}{an \code{n} by \code{d} matrix of observations, each on the positive real line}

\item{family}{family of the Liouville copula. Either \code{"clayton"}, \code{"gumbel"}, \code{"frank"}, \code{"AMH"} or \code{"joe"}}

\item{alphavec}{\code{d}-vector of Dirichlet allocations (must be a vector of integers)}
}
\description{
\code{sliouv} returns the survival function of a Liouville vector. For the survival copula
and the associated probability, see \code{\link{pliouv}}.
}
