% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lorenz.curve.R
\name{lorenz.curve}
\alias{lorenz.curve}
\title{Lorenz Curve}
\usage{
lorenz.curve(
  data,
  weight = NULL,
  mul = FALSE,
  plot.it = TRUE,
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  xlim = c(0, 1),
  ylim = c(0, 1),
  ...
)
}
\arguments{
\item{data}{input data. If the argument is an array, a matrix, a data.frame, or a list 
with two or more columns, then the first column will be treated as a data vector, 
and the second column to be treated as a weight vector. A separate weight vector is 
then ignored and not required. If the argument is a single column vector, then a user 
must enter a separate single-column weight vector. 
\code{NA}s or character are not allowed.}

\item{weight}{one-column vector contains factors of single or multiple weights. 
Ignored if included in the \code{data} argument. 
\code{NA}s or character are not allowed.}

\item{mul}{logical value indicates whether the Lorenz curve with multiple weight 
is to be plotted. Default is \code{FALSE}, i.e., single.}

\item{plot.it}{logical value indicates whether the Lorenz curve should be plotted. 
Default is \code{TRUE}, i.e., to plot.}

\item{main}{title of Lorenz curve. Only required if user wants to override the default value.}

\item{xlab}{label of x-axis. Only required if user wants to override the default value.}

\item{ylab}{label of y-axis. Only required if user wants to override the default value.}

\item{xlim}{plotting range of x-axis. Only required if user wants to override the default value.}

\item{ylim}{plotting range of y-axis. Only required if user wants to override the default value.}

\item{...}{other graphical parameters to be passed to the \code{\link[graphics]{plot}} function.}
}
\value{
A Lorenz curve plot with x-axis being the culmulative fraction of the 
data argument, and y-axis being the culmulative fraction of the weight argument. 
In the legend to the plot, the following values are reported: 
\item{RMD}{relative mean deviation of the input data.}
\item{GI}{the Gini index of the input data.}
\item{L(1/2)}{median of the culmulative fraction sum of the data.}
}
\description{
Plots the Lorenz curve that is a graphical representation of the cumulative 
distribution function. The user can choose between the Lorenz curve with single (default)
or multiple weighting of data, for example, taking into account for single or multiple
legislature representatives \insertCite{Gastwirth_1972}{lawstat}.
}
\details{
The input data should be a data frame with 2 columns. The first column will be 
treated as data vector, and the second column to be treated as a weight vector. 
Alternatively, data and weights can be entered as separate one-column vectors.
}
\examples{
## Data on: number of senators (second column) and 
## representatives (third column) relative to population size (first column) in 1963
## First column is treated as the data argument.
data(data1963)

## Single weight Lorenz Curve using number of senators as weight argument.
lorenz.curve(data1963)

## Multiple weight Lorenz Curve using number of senators as weight argument.
lorenz.curve(data1963, mul = TRUE)

## Multiple weight Lorenz Curve using number of representatives 
## as weight argument.
lorenz.curve(data1963[, "pop1963"], data1963[, "rep1963"], mul = TRUE)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{gini.index}}
}
\author{
Man Jin, Wallace W. Hui, Yulia R. Gel, Joseph L. Gastwirth
}
\keyword{plot}
