% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/has_val_labs.R
\name{has_val_labs}
\alias{has_val_labs}
\alias{hvl}
\title{Is This a Value-labeled Variable (Column)?}
\usage{
has_val_labs(data, var, type = "any")

hvl(data, var, type = "any")
}
\arguments{
\item{data}{a data.frame.}

\item{var}{the unquoted name of the variable (column) to check for the
presence of value labels.}

\item{type}{the type of value label to check the variable for: "any,"
"1to1," "m1," or "q." If "1to1," check will be for value labels added via
\code{add_val_labs()} or \code{add_val1()}. If "m1," check will be for value labels
added via \code{add_m1_lab()} or \code{add1m1()}. If "q," check will be for value
labels added via \code{add_quant_labs()} or \code{add_quant1()}. If "any," will return
TRUE if any of the foregoing value label types is found.}
}
\value{
A 1L logical.
}
\description{
Determine whether a specific variable of a data.frame has value labels
associated with it.
}
\details{
\code{hvl} is a compact alias for \code{has_val_labs}: they do the same thing, and the
former is easier to type
}
\examples{
# add val labs to multiple variables at once
# make a "Likert"-type fake data set to demo
# note, by default, add_val_labs() "vars" arg will do partial matching
# in this case, we catch all vars with "y" in their name, except "y3"
set.seed(272)
dflik <- make_likert_data(scale = 1:7)
vals2label <- 1:7
labs2use <- c(
  "VSD",
  "SD",
  "D",
  "N",
  "A",
  "SA",
  "VSA"
)

dflik <- add_val_labs(
  data = dflik, vars = c("y"), # note the vars args
  not.vars = "y3",
  vals = vals2label,
  labs = labs2use,
  partial = TRUE
)

has_val_labs(dflik, y1) # TRUE

has_val_labs(dflik, y3) # FALSE, see not.vars arg above
}
