% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/val_labs_vec.R
\name{val_labs_vec}
\alias{val_labs_vec}
\alias{vlv}
\title{Replace a Variable's Values with Its Value Labels and Return as a Vector}
\usage{
val_labs_vec(data, var)

vlv(data, var)
}
\arguments{
\item{data}{a data.frame.}

\item{var}{the unquoted name of the column (variable) whose values will be
converted to the associated value labels in the returned vector.}
}
\value{
A vector containing the original data.frame variable (var), after
its values have been converted to their corresponding value labels.
}
\description{
Select a single, value-labeled data.frame column (variable), replace each of
its values with the corresponding value labels, and return the result as a
vector.
}
\details{
Note 1: \code{vlv} is a compact alias for \code{val_labs_vec}: they do the same thing,
and the former is easier to type.

Note 2: This command is intended exclusively for interactive use. In
particular, the var argument must be the literal name of a single variable
(column) found in the supplied data.frame and may NOT be, e.g., the name of a
character vector that contains the variable (column name) of interest.

\code{val_labs_vec} works with other labelr functions to facilitate creation,
modification, accessing, use, and destruction of variable-specific value
labels. This functionality is equivalent to calling \code{use_val_labs} with a
single variable passed to the vars argument, except that the latter returns
the entire data.frame with that variable modified, while \code{val_labs_vec}
returns only that single modified variable itself (as a vector)
}
\examples{
df <- mtcars
# add value labels
df <- add_val_labs(
  data = df,
  var = "am",
  vals = c(0, 1),
  labs = c("automatic", "manual")
)

am_labs <- val_labs_vec(df, am)

length(df$am)

class(df$am)

df$am

length(am_labs)

class(am_labs)

am_labs

}
