# Scientific color schemes =====================================================
schemes_science <- list(
  # Qualitative colour schemes -------------------------------------------------
  # The colours have to be used as given: do not interpolate
  stratigraphy = list(
    type = "qualitative",
    interpolate = FALSE,
    missing = NA_character_,
    max = 175,
    colours = c(
      "#FEF2E0", "#FFF2D3", "#FFF2C7", "#FFF2BA", "#FFEDB3", "#FFF2AE",
      "#F9F97F", "#FFFFBF", "#FFFFB3", "#FFFF99", "#FFFF73", "#FFFF66",
      "#FFFF59", "#FFFF4D", "#FFFF41", "#FFFF33", "#FFFF00", "#FFE619",
      "#FEE6AA", "#FED99A", "#FDC07A", "#FDCDA1", "#FDC091", "#FCB482",
      "#FCA773", "#FDB46C", "#FDBF6F", "#FEBF65", "#FDB462", "#FDA75F",
      "#FD9A52", "#F2F91D", "#F2FA8C", "#E6F47F", "#D9EF74", "#CCE968",
      "#BFE35D", "#B3DE53", "#A6D84A", "#CCEA97", "#BFE48A", "#B3DF7F",
      "#A6D975", "#99D36A", "#8CCD60", "#8CCD57", "#7FC64E", "#D9F1F7",
      "#CCECF4", "#BFE7F1", "#B3E3EE", "#BFE7E5", "#B3E2E3", "#A6DDE0",
      "#9AD9DD", "#80CFD8", "#99CEE3", "#80C5DD", "#67BCD8", "#4EB3D3",
      "#42AED0", "#34B2C9", "#E3B9DB", "#D6AAD3", "#C99BCB", "#BD8CC3",
      "#C983BF", "#BC75B7", "#B168B1", "#B051A5", "#A4469F", "#983999",
      "#812B92", "#67C5CA", "#FCC0B2", "#FCB4A2", "#FBA794", "#FB9A85",
      "#FB8D76", "#FB8069", "#FB745C", "#E38776", "#E37B68", "#E36F5C",
      "#E36350", "#EF5845", "#F04028", "#CCD4C7", "#BFD0C5", "#BFD0BA",
      "#B3CBB9", "#A6C7B7", "#99C2B5", "#8CBEB4", "#99C2B5", "#BFC26B",
      "#B3BE6C", "#A6B96C", "#99B46C", "#8CB06C", "#80AB6C", "#678F66",
      "#67A599", "#F2EDC5", "#F2EDAD", "#F1E19D", "#F1E185", "#F1D576",
      "#F1C868", "#E5D075", "#E5C468", "#E5B75A", "#E5AC4D", "#CB8C37",
      "#E6F5E1", "#D9F0DF", "#CCECDD", "#BFE6CF", "#CCEBD1", "#BFE6C3",
      "#B3E1C2", "#BFE6CF", "#B3E1C2", "#A6DCB5", "#99D7B3", "#B3E1B6",
      "#A6DBAB", "#99D69F", "#8CD094", "#7FCA93", "#74C69C", "#66C092",
      "#4DB47E", "#41B087", "#33A97E", "#1A9D6F", "#009270", "#E6F5C9",
      "#D9F0BB", "#CCEBAE", "#B3E095", "#CCDFAA", "#BFD99D", "#B3D492",
      "#A6CF86", "#B3CA8E", "#A6C583", "#99C078", "#A6BA80", "#99B575",
      "#8CB06C", "#7FA056", "#99C08D", "#9AD9DD", "#FED96A", "#FECC5C",
      "#FEBF4E", "#FEB342", "#FED99A", "#FDCC8A", "#FDC07A", "#FDB462",
      "#F875A7", "#F76898", "#F75B89", "#F74F7C", "#F74370", "#F73563",
      "#F881B5", "#F881B5", "#F668B2", "#E61D8C", "#F0047F", "#AE027E",
      "#F74370"
    ),
    names = list(
      en = c(
        "Holocene", "Upper Pleistocene", "Ionian", "Calabrian", "Gelasian",
        "Pleistocene", "Quaternary", "Piacenzian", "Zanclean", "Pliocene",
        "Messinian", "Tortonian", "Serravallian", "Langhian", "Burdigalian",
        "Aquitanian", "Miocene", "Neogene", "Chattian", "Rupelian", "Oligocene",
        "Priabonian", "Bartonian", "Lutetian", "Ypresian", "Eocene",
        "Thanetian", "Selandian", "Danian", "Paleocene", "Paleogene",
        "Cenozoic", "Maastrichtian", "Campanian", "Santonian", "Coniacian",
        "Turonian", "Cenomanian", "Upper Cretaceous", "Albian", "Aptian",
        "Barremian", "Hauterivian", "Valanginian", "Berriasian", "Lower Cretaceous",
        "Cretaceous", "Tithonian", "Kimmeridgian", "Oxfordian", "Upper Jurassic",
        "Callovian", "Bathonian", "Bajocian", "Aalenian", "Middle Jurassic",
        "Toarcian", "Pliensbachian", "Sinemurian", "Hettangian", "Lower Jurassic",
        "Jurassic", "Rhaetian", "Norian", "Carnian", "Upper Triassic",
        "Ladinian", "Anisian", "Middle Triassic", "Olenekian", "Induan",
        "Lower Triassic", "Triassic", "Mesozoic", "Changhsingian", "Wuchiapingian",
        "Lopingian", "Capitanian", "Wordian", "Roadian", "Guadalupian",
        "Kungurian", "Artinskian", "Sakmarian", "Asselian", "Cisuralian",
        "Permian", "Gzhelian", "Kasimovian", "Upper Pennsylvanian", "Moscovian",
        "Middle Pennsylvanian", "Bashkirian", "Lower Pennsylvanian",
        "Pennsylvanian", "Serpukhovian", "Upper Mississippian", "Visean",
        "Middle Mississippian", "Tournaisian", "Lower Mississippian",
        "Mississippian", "Carboniferous", "Famennian", "Frasnian", "Upper Devonian",
        "Givetian", "Eifelian", "Middle Devonian", "Emsian", "Pragian",
        "Lochkovian", "Lower Devonian", "Devonian", "Pridoli", "Ludfordian",
        "Gorstian", "Ludlow", "Homerian", "Sheinwoodian", "Wenlock",
        "Telychian", "Aeronian", "Rhuddanian", "Llandovery", "Silurian",
        "Hirnantian", "Katian", "Sandbian", "Upper Ordovician", "Darriwilian",
        "Dapingian", "Middle Ordovician", "Floian", "Tremadocian", "Lower Ordovician",
        "Ordovician", "Stage 10", "Jiangshanian", "Paibian", "Furongian",
        "Guzhangian", "Drumian", "Wuliuan", "Miaolingian", "Stage 4",
        "Stage 3", "Series 2", "Stage 2", "Fortunian", "Terreneuvian",
        "Cambrian", "Paleozoic", "Phanerozoic", "Ediacaran", "Cryogenian",
        "Tonian", "Neoproterozoic", "Stenian", "Ectasian", "Calymmian",
        "Mesoproterozoic", "Statherian", "Orosirian", "Rhyacian", "Siderian",
        "Paleoproterozoic", "Proterozoic", "Neoarchean", "Mesoarchean",
        "Paleoarchean", "Eoarchean", "Archean", "Hadean", "Precambrian"
      ),
      fr = c(
        "Holocène", "Pléistocène supérieur", "Ionien", "Calabrien",
        "Gélasien", "Pléistocène", "Quaternaire", "Plaisancien", "Zancléen",
        "Pilocène", "Messinien", "Tortonien", "Serravallien", "Langhien",
        "Burdigalien", "Aquitanien", "Miocène", "Néogène", "Chattien",
        "Rupélien", "Oligocène", "Priabonien", "Bartonien", "Lutétien",
        "Yprésien", "Éocène", "Thanétien", "Sélandien", "Danien",
        "Paléocène", "Paléogène", "Cénozoïque", "Maastrichtien",
        "Campanien", "Santonien", "Coniacien", "Turonien", "Cénomanien",
        "Crétacé supérieur", "Albien", "Aptien", "Barrémien", "Hauterivien",
        "Valanginien", "Berriasien", "Crétacé inférieur", "Crétacé",
        "Tithonien", "Kimméridgien", "Oxfordien", "Jurassique supérieur",
        "Callovien", "Bathonien", "Bajocien", "Aalénien", "Jurassique moyen",
        "Toarcien", "Pliensbachien", "Sinémurien", "Hettangien", "Jurassique inférieur",
        "Jurassique", "Rhétien", "Norien", "Carnien", "Trias supérieur",
        "Ladinien", "Anisien", "Trias moyen", "Olénékien", "Indusien",
        "Trias inférieur", "Trias", "Mésozoïque", "Changhsingien",
        "Wuchiapingien", "Lopingien", "Capitanien", "Wordien", "Roadien",
        "Guadalupien", "Kungurien", "Artinskien", "Sakmarien", "Assélien",
        "Cisuralien", "Permien", "Gzhélien", "Kasimovien", "Pennsylvanien supérieur",
        "Moscovien", "Pennsylvanien moyen", "Bashkirien", "Pennsylvanien inférieur",
        "Pennsylvanien", "Serpukhovien", "Mississippien supérieur",
        "Viséen", "Mississippien moyen", "Tournaisien", "Mississippien inférieur",
        "Mississippien inférieur", "Carbonifère", "Famennien", "Frasnien",
        "Dévonien supérieur", "Givétien", "Eifélien", "Dévonien moyen",
        "Emsien", "Praguien", "Lochkovien", "Dévonien inférieur", "Dévonien",
        "Pridoli", "Ludfordien", "Gorstien", "Ludlow", "Homérien", "Sheinwoodien",
        "Wenlock", "Télychien", "Aéronien", "Rhuddanien", "Llandovery",
        "Silurien", "Hirnantien", "Katien", "Sandbien", "Ordovicien supérieur",
        "Darriwilien", "Dapingien", "Ordovicien moyen", "Floien", "Trémadocien",
        "Ordovicien inférieur", "Ordovicien", "Étage 10", "Jiangshanien",
        "Paibien", "Furongien", "Guzhangien", "Drumien", "Wuliuen", "Miaolingien",
        "Étage 4", "Étage 3", "Série 2", "Étage 2", "Fortunien",
        "Terreneuvien", "Cambrien", "Paléozoïque", "Phanérozoïque",
        "Édiacarien", "Cryogénien", "Tonien", "Néoprotérozoïque",
        "Sténien", "Ectasien", "Calymmien", "Mésoprotérozoïque",
        "Stathérien", "Orosirien", "Rhyacien", "Sidérien", "Paléoprotérozoïque",
        "Protérozoïque", "Néoarchéen", "Mésoarchéen", "Paléoarchéen",
        "Éoarchéen", "Archéen", "Hadéen", "Précambrien")
    ),
    scheme = NULL
  ),
  soil = list(
    type = "qualitative",
    interpolate = FALSE,
    missing = NA_character_,
    max = 24,
    colours = c("#795f35", "#fbc1af", "#ef2c30", "#706d6e", "#f4d49d",
                "#ffee00", "#fbc41e", "#b45241", "#5a69b2", "#1ab3ef",
                "#dd9785", "#938abb", "#fff4a4", "#86817e", "#d8d7d7",
                "#f58971", "#e56d4c", "#f2833f", "#28b45d", "#fde09f",
                "#ee1a95", "#f6c4e5", "#618f75", "#9d4076"
    ),
    names = list(
      en = c("Acrisol", "Albeluvisol", "Andosol", "Anthrosol",
             "Arenosol", "Calcisol", "Cambisol", "Chernozem",
             "Cryosol", "Fluvisol", "Kastanozem", "Gleysol",
             "Gypsisol", "Histosol", "Leptosol", "Luvisol",
             "Phaeozem", "Planosol", "Podzol", "Regosol",
             "Solonchak", "Solonetz", "Umbrisol", "Vertisol"),
      fr = c("Acrisol", "Albeluvisol", "Andosol", "Anthrosol",
             "Arenosol", "Calcisol", "Cambisol", "Chernozem",
             "Cryosol", "Fluvisol", "Kastanozem", "Gleysol",
             "Gypsisol", "Histosol", "Leptosol", "Luvisol",
             "Phaeozem", "Planosol", "Podzol", "Regosol",
             "Solonchak", "Solonetz", "Umbrisol", "Vertisol")
    ),
    scheme = NULL
  ),
  # Paul Tol"s Colour-blind safe colour scheme for
  # the AVHRR global land cover classification
  land = list(
    type = "qualitative",
    interpolate = FALSE,
    missing = NA_character_,
    max = 14,
    colours = c("#5566AA", "#117733", "#44AA66", "#55AA22", "#668822",
                "#99BB55", "#558877", "#88BBAA", "#AADDCC", "#44AA88",
                "#DDCC66", "#FFDD44", "#FFEE88", "#BB0011"),
    names = list(
      en = c("water", "evergreen needleleaf forest",
             "deciduous needleleaf forest", "mixed forest",
             "evergreen broadleaf forest", "deciduous broadleaf forest",
             "woodland", "wooded grassland", "grassland", "cropland",
             "closed shrubland", "open shrubland", "bare ground",
             "urban and built"),
      fr = c("eau", "forêts de conifères boréales",
             "forêts de conifères tropicales et subtropicales",
             "forêts tempérées décidues et mixtes",
             "forêts décidues humides tropicales et subtropicales",
             "forêts décidues sèches tropicales et subtropicales",
             "", "", "prairies", "terres cultivées",
             "végétation arbustive dense", "Végétation arbustive clairsemée",
             "", "zones urbaines")
    ),
    scheme = NULL
  )
)
