% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2.R
\name{scale_picker}
\alias{scale_picker}
\alias{scale_colour_picker}
\alias{scale_color_picker}
\alias{scale_fill_picker}
\alias{scale_edge_colour_picker}
\alias{scale_edge_color_picker}
\alias{scale_edge_fill_picker}
\title{Color Scale Builder}
\usage{
scale_colour_picker(..., palette = "YlOrBr")

scale_color_picker(..., palette = "YlOrBr")

scale_fill_picker(..., palette = "YlOrBr")

scale_edge_colour_picker(..., palette = "YlOrBr")

scale_edge_color_picker(..., palette = "YlOrBr")

scale_edge_fill_picker(..., palette = "YlOrBr")
}
\arguments{
\item{...}{Extra parameters to be passed to the color scale function.}

\item{palette}{A \code{\link{character}} string giving the name of the color scheme to
be used (see \code{\link[=info]{info()}}).}
}
\value{
A \link[ggplot2:discrete_scale]{discrete} or
\link[ggplot2:continuous_scale]{continuous} scale.
}
\description{
Builds a color scale for \pkg{ggplot2} or \pkg{ggraph}.
}
\examples{
library(ggplot2)

ggplot2::ggplot(mpg, ggplot2::aes(displ, hwy, colour = class)) +
  ggplot2::geom_point() +
  scale_colour_picker(palette = "okabeito")
}
\seealso{
Other color palettes: 
\code{\link{colour}()},
\code{\link{info}()},
\code{\link{ramp}()}
}
\author{
N. Frerebeau
}
\concept{color palettes}
