% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/access-methods.R
\docType{methods}
\name{PredictionProfileAccessors}
\alias{PredictionProfileAccessors}
\alias{[,PredictionProfile,index,ANY,ANY-method}
\alias{baselines}
\alias{baselines,PredictionProfile-method}
\alias{profiles}
\alias{profiles,PredictionProfile-method}
\alias{sequences}
\alias{sequences,PredictionProfile-method}
\title{PredictionProfile Accessors}
\usage{
\S4method{sequences}{PredictionProfile}(object)
}
\arguments{
\item{object}{a prediction profile object}
}
\value{
\code{sequences}: sequences for which profiles were generated\cr
\code{profiles}: prediction profiles\cr
\code{baselines}: baselines for the plot, this is the model offset\cr
distributed to all sequence positions
}
\description{
PredictionProfile Accessors
}
\section{Accessor-like methods}{

  In the descriptions below, \code{object} and \code{x} are objects of class
  \code{\linkS4class{PredictionProfile}}.

\describe{
  \item{\code{sequences(object)}}{
  returns the sequences.
  }
  \item{\code{profiles(object)}}{
  return the prediction profiles.
  }
  \item{\code{baselines(object)}}{
  return the baselines.
  }
  \item{\code{x[i]}}{
  return a \code{PredictionProfile} object that only contains the
  prediction profiles selected with the subsetting parameter \code{i}. This
  parameter can be a numeric vector with indices or a character vector with
  sample names.
  }
}
}
\examples{
## create kernel object for gappy pair kernel
gappy <- gappyPairKernel(k=1,m=11, annSpec=TRUE)
\dontrun{
## load data
data(CCoil)

## perform training - feature weights are computed by default
model <- kbsvm(ccseq, yCC, gappya, pkg="LiblineaR", svm="C-svc", cost=15)

## compute prediction profiles
predProf <- getPredictionProfile(ccseq, gappya,
                                 featureWeights(model),
                                 modelOffset(model))
predProf15 <- predProf[c(1,5),]
sequences(predProf15)
profiles(predProf15)
baselines(predProf15)
}
}
\author{
Johannes Palme <kebabs@bioinf.jku.at>
}
\references{
\url{http://www.bioinf.jku.at/software/kebabs/}\cr\cr
J. Palme, S. Hochreiter, and U. Bodenhofer (2015) KeBABS: an R package
for kernel-based analysis of biological sequences.
\emph{Bioinformatics}, 31(15):2574-2576, 2015.
DOI: \doi{10.1093/bioinformatics/btv176}.
}

