% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/show-methods.R
\docType{methods}
\name{show.BioVector}
\alias{show}
\alias{show,BioVector-method}
\alias{show,CrossValidationResult-method}
\alias{show,ExplicitRepresentationDense-method}
\alias{show,ExplicitRepresentationSparse-method}
\alias{show,GappyPairKernel-method}
\alias{show,KBModel-method}
\alias{show,MismatchKernel-method}
\alias{show,ModelSelectionResult-method}
\alias{show,MotifKernel-method}
\alias{show,PredictionProfile-method}
\alias{show,ROCData-method}
\alias{show,SVMInformation-method}
\alias{show,SpectrumKernel-method}
\alias{show,SymmetricPairKernel-method}
\alias{show.BioVector}
\title{Display Various KeBABS Objects}
\usage{
show.BioVector(object)

\S4method{show}{PredictionProfile}(object)

\S4method{show}{SpectrumKernel}(object)

\S4method{show}{MismatchKernel}(object)

\S4method{show}{MotifKernel}(object)

\S4method{show}{GappyPairKernel}(object)

\S4method{show}{SymmetricPairKernel}(object)

\S4method{show}{ExplicitRepresentationDense}(object)

\S4method{show}{ExplicitRepresentationSparse}(object)

\S4method{show}{CrossValidationResult}(object)

\S4method{show}{ModelSelectionResult}(object)

\S4method{show}{SVMInformation}(object)

\S4method{show}{KBModel}(object)

\S4method{show}{ROCData}(object)
}
\arguments{
\item{object}{object of class BioVector, PredictionProfile,
SpectrumKernel, MismatchKernel, GappyPairKernel,
MotifKernel, SymmetricPairKernel, ExplicitRepresentation,
ExplicitRepresentationSparse, PredictionProfile, CrossValidationResult,
ModelSelectionResult, SVMInformation or KBModel to be displayed}
}
\value{
\code{show}: show returns an invisible \code{NULL}
}
\description{
Display methods for BioVector, SpectrumKernel, MismatchKernel,
GappyPairKernel, MotifKernel, SymmetricPairKernel,
ExplicitRepresentationDense, ExplicitRepresentationSparse,
PredictionProfile, CrossValidationResult, ModelSelectionResult,
SVMInformation and KBModel objects
}
\details{
\code{show} displays on overview of the selected object.
}
\examples{
## load coiled coil data
data(CCoil)

## show amino acid sequences
ccseq

## define spectrum kernel object
specK1 <- spectrumKernel(k=1, normalized=FALSE)

## show kernel object
show(specK1)

## compute explicit representation for the first 5 sequences
## in dense format
er <- getExRep(ccseq, specK1, sel=1:5, sparse=FALSE)

## show dense explicit representation
show(er)
}
\author{
Johannes Palme <kebabs@bioinf.jku.at>
}
\references{
\url{http://www.bioinf.jku.at/software/kebabs/}\cr\cr
J. Palme, S. Hochreiter, and U. Bodenhofer (2015) KeBABS: an R package
for kernel-based analysis of biological sequences.
\emph{Bioinformatics}, 31(15):2574-2576, 2015.
DOI: \doi{10.1093/bioinformatics/btv176}.
}

