% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cov.r
\docType{methods}
\name{cov}
\alias{cov}
\alias{cov,shaq-method}
\alias{cor,shaq-method}
\title{Covariance and Correlation}
\usage{
\S4method{cov}{shaq}(x, y = NULL, use = "everything", method = "pearson")

\S4method{cor}{shaq}(x, y = NULL, use = "everything", method = "pearson")
}
\arguments{
\item{x}{A shaq.}

\item{y}{At this time, this must be \code{NULL}.}

\item{use}{NA handling rules, as with R's cov/cor functions.  At this time, only
"everything" is supported.}

\item{method}{The cov/cor method. Currently only "pearson" is available.}
}
\value{
A regular matrix.
}
\description{
Covariance and (pearson) correlation.
}
\section{Communication}{

The operation is completely local except for forming the crossproduct, which
is an \code{allreduce()} call, quadratic on the number of columns.
}

\examples{
\dontrun{
library(kazaam)
x = ranshaq(runif, 10, 3)

cov(x)
cor(x)

finalize()
}

}
