% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jqr.R
\name{jqr_new}
\alias{jqr_new}
\alias{jqr_feed}
\title{JQ Streaming API}
\usage{
jqr_new(query, flags = jq_flags())

jqr_feed(jqr_program, json, unlist = TRUE, finalize = FALSE)
}
\arguments{
\item{query}{string with a valid jq program}

\item{flags}{See \code{\link{jq_flags}}}

\item{jqr_program}{object returned by [jqr_new]}

\item{json}{character vector with json data. If the JSON object is incomplete, you
must set `finalize` to `FALSE` otherwise you get an error.}

\item{unlist}{if `TRUE` returns a single character vector with all output for each
each string in `json` input}

\item{finalize}{completes the parsing and verifies that the JSON string is valid. Set
this to `TRUE` when feeding the final piece of data.}
}
\description{
Low level JQ API. First create a program using a `query` and `flags` and then
feed pieces of data.
}
\examples{
program <- jqr_new(".[]")
jqr_feed(program, c("[123, 456]", "[77, 88, 99]"))
jqr_feed(program, c("[41, 234]"))
jqr_feed(program, "", finalize = TRUE)
}
