% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Kostka.R
\name{skewKostkaJackNumbers}
\alias{skewKostkaJackNumbers}
\title{Skew Kostka-Jack numbers with given Jack parameter}
\usage{
skewKostkaJackNumbers(lambda, mu, alpha = NULL, output = "vector")
}
\arguments{
\item{lambda, mu}{integer partitions defining the skew partition:
\code{lambda} is the outer partition and \code{mu} is the inner partition
(so \code{mu} must be a subpartition of \code{lambda})}

\item{alpha}{the Jack parameter, a \code{bigq} number or an object coercible
to a \code{bigq} number; setting \code{alpha=NULL} is equivalent to set
\code{alpha=1}}

\item{output}{the format of the output, either \code{"vector"} or
\code{"list"}}
}
\value{
If \code{output="vector"}, the function returns a named vector.
  This vector is made of the non-zero skew Kostka-Jack numbers
  \eqn{K_{\lambda/\mu,\nu}(\alpha)} given as character strings and its names
  encode the partitions \eqn{\nu}.
  If \code{ouput="list"}, the function returns a list. Each element of this
  list is a named list with two elements: an integer partition \eqn{\nu}
  in the field named \code{"nu"}, and the corresponding skew Kostka-Jack
  number \eqn{K_{\lambda/\mu,\nu}(\alpha)} in the field named \code{"value"}.
  Only the non-null skew Kostka-Jack numbers are provided by this list.
}
\description{
Skew Kostka-Jack numbers associated to a given skew partition
  and a given Jack parameter.
}
\details{
The skew Kostka-Jack number \eqn{K_{\lambda/\mu,\nu}(\alpha)} is
  the coefficient of the monomial symmetric polynomial \eqn{m_\nu} in the
  expression of the skew \eqn{P}-Jack polynomial
  \eqn{P_{\lambda/\mu}(\alpha)} as a linear combination of monomial
  symmetric polynomials. For \eqn{\alpha=1} it is the ordinary skew Kostka
  number.
}
\note{
The skew Kostka-Jack numbers \eqn{K_{\lambda/\mu,\nu}(\alpha)} are
  well defined when the Jack parameter \eqn{\alpha} is zero, however this
  function does not work with \code{alpha=0}. A possible way to get the
  skew Kostka-Jack numbers \eqn{K_{\lambda/\mu,\nu}(0)} is to use the
  function \code{\link{symbolicSkewKostkaJackNumbers}} to get the skew
  Kostka-Jack numbers with a symbolic Jack parameter \eqn{\alpha}, and then
  to substitute \eqn{\alpha} with \eqn{0}.
}
\examples{
skewKostkaJackNumbers(c(4,2,2), c(2,2))
}
\seealso{
\code{\link{symbolicSkewKostkaJackNumbers}}.
}
