% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit_functions.R
\name{moment_match.brmsfit}
\alias{moment_match.brmsfit}
\title{Generic importance weighted moment matching algorithm for \code{brmsfit} objects.
See additional arguments from \code{moment_match.matrix}}
\usage{
\method{moment_match}{brmsfit}(
  x,
  log_prob_target_fun = NULL,
  log_ratio_fun = NULL,
  target_observation_weights = NULL,
  expectation_fun = NULL,
  log_expectation_fun = FALSE,
  constrain = TRUE,
  ...
)
}
\arguments{
\item{x}{A fitted \code{brmsfit} object.}

\item{log_prob_target_fun}{Log density of the target.  The function
takes argument \code{draws}, which are the unconstrained draws.
Can also take the argument \code{fit} which is the stan model fit.}

\item{log_ratio_fun}{Log of the density ratio (target/proposal).
The function takes argument \code{draws}, which are the unconstrained
draws. Can also take the argument \code{fit} which is the stan model fit.}

\item{target_observation_weights}{A vector of weights for observations for
defining the target distribution. A value 0 means dropping the observation,
a value 1 means including the observation similarly as in the current data,
and a value 2 means including the observation twice.}

\item{expectation_fun}{Optional argument, NULL by default. A
function whose expectation is being computed. The function takes
arguments \code{draws}.}

\item{log_expectation_fun}{Logical indicating whether the
expectation_fun returns its values as logarithms or not. Defaults
to FALSE. If set to TRUE, the expectation function must be
nonnegative (before taking the logarithm).  Ignored if
\code{expectation_fun} is NULL.}

\item{constrain}{Logical specifying whether to return draws on the
constrained space? Default is TRUE.}

\item{...}{Further arguments passed to \code{moment_match.matrix}.}
}
\value{
Returns a list with 3 elements: transformed draws, updated
importance weights, and the pareto k diagnostic value. If expectation_fun
is given, also returns the expectation.
}
\description{
Generic importance weighted moment matching algorithm for \code{brmsfit} objects.
See additional arguments from \code{moment_match.matrix}
}
